/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;

public class XmlBasedFileIndexerProvider
extends AbstractIndexerProvider {
    private XMLInputFactory factory = XMLInputFactory.newInstance();

    public XmlBasedFileIndexerProvider() {
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
    }

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.xsl", "*:file:*.xslt", "*:file:*.xsd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        HashSet<String> stringSet = new HashSet<String>();
        XMLStreamReader reader = null;
        try (InputStream inputStream = entry.getInputStream();){
            reader = this.factory.createXMLStreamReader(inputStream);
            stringSet.add(reader.getVersion());
            stringSet.add(reader.getEncoding());
            stringSet.add(reader.getCharacterEncodingScheme());
            block25: while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        int i;
                        stringSet.add(reader.getLocalName());
                        for (i = reader.getAttributeCount() - 1; i >= 0; --i) {
                            stringSet.add(reader.getAttributeLocalName(i));
                            stringSet.add(reader.getAttributeValue(i));
                        }
                        for (i = reader.getNamespaceCount() - 1; i >= 0; --i) {
                            stringSet.add(reader.getNamespacePrefix(i));
                            stringSet.add(reader.getNamespaceURI(i));
                        }
                        continue block25;
                    }
                    case 3: {
                        stringSet.add(reader.getPITarget());
                        stringSet.add(reader.getPIData());
                        break;
                    }
                    case 7: {
                        stringSet.add(reader.getVersion());
                        stringSet.add(reader.getEncoding());
                        stringSet.add(reader.getCharacterEncodingScheme());
                        break;
                    }
                    case 9: {
                        stringSet.add(reader.getLocalName());
                        stringSet.add(reader.getText());
                        break;
                    }
                    case 10: {
                        stringSet.add(reader.getPrefix());
                        stringSet.add(reader.getNamespaceURI());
                        stringSet.add(reader.getLocalName());
                        stringSet.add(reader.getText());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 11: 
                    case 12: {
                        stringSet.add(reader.getText().trim());
                        break;
                    }
                    case 13: {
                        int i;
                        for (i = reader.getNamespaceCount() - 1; i >= 0; --i) {
                            stringSet.add(reader.getNamespacePrefix(i));
                            stringSet.add(reader.getNamespaceURI(i));
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
        }
        finally {
            block33: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block33;
                        throw new AssertionError();
                    }
                }
            }
        }
        XmlBasedFileIndexerProvider.indexStrings(entry, indexes, stringSet);
    }

    private static void indexStrings(Container.Entry entry, Indexes indexes, Set<String> stringSet) {
        Map<String, Collection> stringIndex = indexes.getIndex("strings");
        for (String string : stringSet) {
            if (string == null || string.isEmpty()) continue;
            stringIndex.get(string).add(entry);
        }
    }
}

