/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.XmlBasedFileIndexerProvider;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.util.xml.AbstractXmlPathFinder;

public class WebXmlFileIndexerProvider
extends XmlBasedFileIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:WEB-INF/web.xml");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block8: {
            super.index(api, entry, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
            try (InputStream inputStream = entry.getInputStream();){
                new WebXmlPathFinder(entry, indexes).find(TextReader.getText(inputStream));
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    protected static class WebXmlPathFinder
    extends AbstractXmlPathFinder {
        private Container.Entry entry;
        private Map<String, Collection> index;

        public WebXmlPathFinder(Container.Entry entry, Indexes indexes) {
            super(Arrays.asList("web-app/filter/filter-class", "web-app/listener/listener-class", "web-app/servlet/servlet-class"));
            this.entry = entry;
            this.index = indexes.getIndex("typeReferences");
        }

        @Override
        public void handle(String path, String text, int position) {
            this.index.get(text.replace('.', '/')).add(this.entry);
        }
    }
}

