/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.ProgressUtil;

public class PropertyFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.properties");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block12: {
            HashSet<String> stringSet;
            block11: {
                stringSet = new HashSet<String>();
                try (InputStream inputStream = entry.getInputStream();){
                    Properties props = new Properties();
                    props.load(inputStream);
                    for (Map.Entry<Object, Object> property : props.entrySet()) {
                        stringSet.add(property.getKey().toString());
                        stringSet.add(property.getValue().toString());
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block11;
                    throw new AssertionError();
                }
            }
            PropertyFileIndexerProvider.indexAll(entry, indexes, stringSet);
            try {
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block12;
                throw new AssertionError();
            }
        }
    }

    private static void indexAll(Container.Entry entry, Indexes indexes, Set<String> stringSet) {
        Map<String, Collection> stringIndex = indexes.getIndex("strings");
        for (String string : stringSet) {
            if (string == null || string.isEmpty()) continue;
            stringIndex.get(string).add(entry);
        }
    }
}

