/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.regex.Pattern;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;

public class MetainfServiceFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*");
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern != null ? this.externalPathPattern : Pattern.compile("META-INF\\/services\\/[^\\/]+");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block8: {
            Map<String, Collection> index = indexes.getIndex("typeReferences");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(entry.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    String trim = line.trim();
                    if (trim.isEmpty() || trim.charAt(0) == '#') continue;
                    String internalTypeName = trim.replace('.', '/');
                    index.get(internalTypeName).add(entry);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }
}

