/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class JavaModuleInfoFileIndexerProvider
extends AbstractIndexerProvider {
    protected Set<String> javaModuleDeclarationSet = new HashSet<String>();
    protected Set<String> javaModuleReferenceSet = new HashSet<String>();
    protected Set<String> typeReferenceSet = new HashSet<String>();
    protected ClassIndexer classIndexer = new ClassIndexer();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("jmod:file:classes/module-info.class");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block8: {
            this.javaModuleDeclarationSet.clear();
            this.javaModuleReferenceSet.clear();
            this.typeReferenceSet.clear();
            try (InputStream inputStream = entry.getInputStream();){
                ClassReader classReader = new ClassReader(inputStream);
                classReader.accept((ClassVisitor)this.classIndexer, 7);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "javaModuleDeclarations", this.javaModuleDeclarationSet, entry);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "javaModuleReferences", this.javaModuleReferenceSet, entry);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "typeReferences", this.typeReferenceSet, entry);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    protected class ClassIndexer
    extends ClassVisitor {
        private ModuleIndexer moduleIndexer;

        public ClassIndexer() {
            super(589824);
            this.moduleIndexer = new ModuleIndexer();
        }

        public ModuleVisitor visitModule(String moduleName, int moduleFlags, String moduleVersion) {
            JavaModuleInfoFileIndexerProvider.this.javaModuleDeclarationSet.add(moduleName);
            return this.moduleIndexer;
        }
    }

    protected class ModuleIndexer
    extends ModuleVisitor {
        public ModuleIndexer() {
            super(589824);
        }

        public void visitMainClass(String mainClass) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(mainClass);
        }

        public void visitRequire(String module, int access, String version) {
            JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet.add(module);
        }

        public void visitUse(String service) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(service);
        }

        public void visitExport(String packaze, int access, String ... modules) {
            if (modules != null) {
                Collections.addAll(JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet, modules);
            }
        }

        public void visitOpen(String packaze, int access, String ... modules) {
            if (modules != null) {
                Collections.addAll(JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet, modules);
            }
        }

        public void visitProvide(String service, String ... providers) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(service);
            if (providers != null) {
                Collections.addAll(JavaModuleInfoFileIndexerProvider.this.typeReferenceSet, providers);
            }
        }
    }
}

