/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.model.container.entry.path.DirectoryEntryPath;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.spi.Indexer;

public class JavaModuleFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.jmod");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        DirectoryEntryPath classesDir = new DirectoryEntryPath("classes");
        Container.Entry e = entry.getChildren().get(classesDir);
        if (e != null) {
            Map<String, Collection> packageDeclarationIndex = indexes.getIndex("packageDeclarations");
            JavaModuleFileIndexerProvider.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction, packageDeclarationIndex);
        }
    }

    protected static void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction, Map<String, Collection> packageDeclarationIndex) {
        for (Container.Entry e : entry.getChildren().values()) {
            if (e.isDirectory()) {
                String path = e.getPath();
                if (!path.startsWith("classes/META-INF")) {
                    packageDeclarationIndex.get(path.substring(8)).add(e);
                }
                JavaModuleFileIndexerProvider.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction, packageDeclarationIndex);
                continue;
            }
            Indexer indexer = api.getIndexer(e);
            if (indexer == null) continue;
            indexer.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
        }
    }
}

