/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.ProgressUtil;
import org.jd.gui.util.parser.jdt.ASTParserFactory;
import org.jd.gui.util.parser.jdt.core.AbstractJavaListener;

public class JavaFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.java");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block4: {
            try {
                Listener listener = new Listener(entry);
                ASTParserFactory.getInstance().newASTParser(entry).createAST(null).accept((ASTVisitor)listener);
                JavaFileIndexerProvider.addToIndexes(indexes, "typeDeclarations", listener.getTypeDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "constructorDeclarations", listener.getConstructorDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "methodDeclarations", listener.getMethodDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "fieldDeclarations", listener.getFieldDeclarationSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "typeReferences", listener.getTypeReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "constructorReferences", listener.getConstructorReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "methodReferences", listener.getMethodReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "fieldReferences", listener.getFieldReferenceSet(), entry);
                JavaFileIndexerProvider.addToIndexes(indexes, "strings", listener.getStringSet(), entry);
                Map<String, Collection> index = indexes.getIndex("subTypeNames");
                for (Map.Entry<String, Set<String>> e : listener.getSuperTypeNamesMap().entrySet()) {
                    String typeName = e.getKey();
                    for (String superTypeName : e.getValue()) {
                        index.get(superTypeName).add(typeName);
                    }
                }
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block4;
                throw new AssertionError();
            }
        }
    }

    protected static class Listener
    extends AbstractJavaListener {
        private Set<String> typeDeclarationSet = new HashSet<String>();
        private Set<String> constructorDeclarationSet = new HashSet<String>();
        private Set<String> methodDeclarationSet = new HashSet<String>();
        private Set<String> fieldDeclarationSet = new HashSet<String>();
        private Set<String> typeReferenceSet = new HashSet<String>();
        private Set<String> constructorReferenceSet = new HashSet<String>();
        private Set<String> methodReferenceSet = new HashSet<String>();
        private Set<String> fieldReferenceSet = new HashSet<String>();
        private Set<String> stringSet = new HashSet<String>();
        private Map<String, Set<String>> superTypeNamesMap = new HashMap<String, Set<String>>();
        private StringBuilder sbTypeDeclaration = new StringBuilder();

        public Listener(Container.Entry entry) {
            super(entry);
        }

        public Set<String> getTypeDeclarationSet() {
            return this.typeDeclarationSet;
        }

        public Set<String> getConstructorDeclarationSet() {
            return this.constructorDeclarationSet;
        }

        public Set<String> getMethodDeclarationSet() {
            return this.methodDeclarationSet;
        }

        public Set<String> getFieldDeclarationSet() {
            return this.fieldDeclarationSet;
        }

        public Set<String> getTypeReferenceSet() {
            return this.typeReferenceSet;
        }

        public Set<String> getConstructorReferenceSet() {
            return this.constructorReferenceSet;
        }

        public Set<String> getMethodReferenceSet() {
            return this.methodReferenceSet;
        }

        public Set<String> getFieldReferenceSet() {
            return this.fieldReferenceSet;
        }

        public Set<String> getStringSet() {
            return this.stringSet;
        }

        public Map<String, Set<String>> getSuperTypeNamesMap() {
            return this.superTypeNamesMap;
        }

        @Override
        public boolean visit(PackageDeclaration node) {
            if (super.visit(node) && !this.packageName.isEmpty()) {
                this.sbTypeDeclaration.append(this.packageName).append('/');
            }
            return true;
        }

        @Override
        protected boolean enterTypeDeclaration(AbstractTypeDeclaration node, int flag) {
            String superQualifiedTypeName;
            String typeName = node.getName().getIdentifier();
            int length = this.sbTypeDeclaration.length();
            if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
                this.sbTypeDeclaration.append(typeName);
            } else {
                this.sbTypeDeclaration.append('$').append(typeName);
            }
            String internalTypeName = this.sbTypeDeclaration.toString();
            this.typeDeclarationSet.add(internalTypeName);
            this.nameToInternalTypeName.put(typeName, internalTypeName);
            HashSet<String> superInternalTypeNameSet = new HashSet<String>();
            Type superTypeIdentifier = this.getSuperType(node);
            if (superTypeIdentifier != null && (superQualifiedTypeName = this.resolveInternalTypeName(superTypeIdentifier)).charAt(0) != '*') {
                superInternalTypeNameSet.add(superQualifiedTypeName);
            }
            if (node instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                List superInterfaces = typeDeclaration.superInterfaceTypes();
                for (Type superInteface : superInterfaces) {
                    String superQualifiedInterfaceName = this.resolveInternalTypeName(superInteface);
                    if (superQualifiedInterfaceName.charAt(0) == '*') continue;
                    superInternalTypeNameSet.add(superQualifiedInterfaceName);
                }
            }
            if (!superInternalTypeNameSet.isEmpty()) {
                this.superTypeNamesMap.put(internalTypeName, superInternalTypeNameSet);
            }
            return true;
        }

        @Override
        public void exitTypeDeclaration() {
            int index = this.sbTypeDeclaration.lastIndexOf("$");
            if (index == -1) {
                index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
            }
            if (index == -1) {
                this.sbTypeDeclaration.setLength(0);
            } else {
                this.sbTypeDeclaration.setLength(index);
            }
        }

        public boolean visit(SimpleType node) {
            String internalTypeName = this.resolveInternalTypeName((Type)node);
            if (internalTypeName.charAt(0) != '*') {
                this.typeReferenceSet.add(internalTypeName);
            }
            return true;
        }

        public boolean visit(FieldDeclaration node) {
            List fragments = node.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                this.fieldDeclarationSet.add(fragment.getName().getIdentifier());
            }
            return true;
        }

        public boolean visit(MethodDeclaration node) {
            if (node.isConstructor()) {
                this.constructorDeclarationSet.add(node.getName().getIdentifier());
            } else {
                this.methodDeclarationSet.add(node.getName().getIdentifier());
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            Type type = node.getType();
            String typeString = Listener.typeToString(type);
            this.constructorReferenceSet.add(typeString);
            return true;
        }

        public boolean visit(FieldAccess node) {
            this.fieldReferenceSet.add(node.getName().getIdentifier());
            return true;
        }

        public boolean visit(MethodInvocation node) {
            this.methodReferenceSet.add(node.getName().getIdentifier());
            return true;
        }

        public boolean visit(StringLiteral node) {
            this.stringSet.add(node.getLiteralValue());
            return true;
        }
    }
}

