/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.ProgressUtil;

public class ImageFileIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.jpg", "*:file:*.jpeg", "*:file:*.png", "*:file:*.gif", "*:file:*.bmp");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block9: {
            try (InputStream inputStream = entry.getInputStream();){
                String entryPath = entry.getPath();
                int startIndex = entryPath.lastIndexOf(47);
                int endIndex = entryPath.lastIndexOf(46);
                if (startIndex != -1 && endIndex != -1) {
                    String imageFileName = entryPath.substring(startIndex + 1, endIndex);
                    String extension = entryPath.substring(endIndex + 1);
                    Map<String, Collection> strings = indexes.getIndex("strings");
                    strings.get(imageFileName).add(entry);
                    strings.get(extension).add(entry);
                }
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
    }
}

