/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.XmlBasedFileIndexerProvider;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.util.xml.AbstractXmlPathFinder;

public class EjbJarXmlFileIndexerProvider
extends XmlBasedFileIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:META-INF/ejb-jar.xml");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block8: {
            super.index(api, entry, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
            try (InputStream inputStream = entry.getInputStream();){
                new EjbJarXmlPathFinder(entry, indexes).find(TextReader.getText(inputStream));
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    public static class EjbJarXmlPathFinder
    extends AbstractXmlPathFinder {
        private Container.Entry entry;
        private Map<String, Collection> index;

        public EjbJarXmlPathFinder(Container.Entry entry, Indexes indexes) {
            super(Arrays.asList("ejb-jar/assembly-descriptor/application-exception/exception-class", "ejb-jar/assembly-descriptor/interceptor-binding/interceptor-class", "ejb-jar/enterprise-beans/entity/home", "ejb-jar/enterprise-beans/entity/remote", "ejb-jar/enterprise-beans/entity/ejb-class", "ejb-jar/enterprise-beans/entity/prim-key-class", "ejb-jar/enterprise-beans/message-driven/ejb-class", "ejb-jar/enterprise-beans/message-driven/messaging-type", "ejb-jar/enterprise-beans/message-driven/resource-ref/injection-target/injection-target-class", "ejb-jar/enterprise-beans/message-driven/resource-env-ref/injection-target/injection-target-class", "ejb-jar/enterprise-beans/session/home", "ejb-jar/enterprise-beans/session/local", "ejb-jar/enterprise-beans/session/remote", "ejb-jar/enterprise-beans/session/business-local", "ejb-jar/enterprise-beans/session/business-remote", "ejb-jar/enterprise-beans/session/service-endpoint", "ejb-jar/enterprise-beans/session/ejb-class", "ejb-jar/enterprise-beans/session/ejb-ref/home", "ejb-jar/enterprise-beans/session/ejb-ref/remote", "ejb-jar/interceptors/interceptor/around-invoke/class", "ejb-jar/interceptors/interceptor/ejb-ref/home", "ejb-jar/interceptors/interceptor/ejb-ref/remote", "ejb-jar/interceptors/interceptor/interceptor-class"));
            this.entry = entry;
            this.index = indexes.getIndex("typeReferences");
        }

        @Override
        public void handle(String path, String text, int position) {
            this.index.get(text.replace('.', '/')).add(this.entry);
        }
    }
}

