/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.spi.Indexer;

public class DirectoryIndexerProvider
extends AbstractIndexerProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:dir:*");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        int depth;
        block2: {
            depth = 15;
            try {
                depth = Integer.parseInt(api.getPreferences().get("DirectoryIndexerPreferences.maximumDepth"));
            }
            catch (NumberFormatException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block2;
                throw new AssertionError();
            }
        }
        this.index(api, entry, indexes, getProgressFunction, setProgressFunction, isCancelledFunction, depth);
    }

    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction, int depth) {
        if (depth-- > 0) {
            for (Container.Entry e : entry.getChildren().values()) {
                if (e.isDirectory()) {
                    this.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction, depth);
                    continue;
                }
                Indexer indexer = api.getIndexer(e);
                if (indexer == null) continue;
                indexer.index(api, e, indexes, getProgressFunction, setProgressFunction, isCancelledFunction);
            }
        }
    }
}

