/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.regex.Pattern;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.ProgressUtil;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassFileIndexerProvider
extends AbstractIndexerProvider {
    protected Set<String> typeDeclarationSet = new HashSet<String>();
    protected Set<String> constructorDeclarationSet = new HashSet<String>();
    protected Set<String> methodDeclarationSet = new HashSet<String>();
    protected Set<String> fieldDeclarationSet = new HashSet<String>();
    protected Set<String> typeReferenceSet = new HashSet<String>();
    protected Set<String> constructorReferenceSet = new HashSet<String>();
    protected Set<String> methodReferenceSet = new HashSet<String>();
    protected Set<String> fieldReferenceSet = new HashSet<String>();
    protected Set<String> stringSet = new HashSet<String>();
    protected Set<String> superTypeNameSet = new HashSet<String>();
    protected Set<String> descriptorSet = new HashSet<String>();
    protected ClassIndexer classIndexer = new ClassIndexer();
    protected SignatureIndexer signatureIndexer = new SignatureIndexer();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public Pattern getPathPattern() {
        if (this.externalPathPattern == null) {
            return Pattern.compile("^((?!module-info\\.class).)*$");
        }
        return this.externalPathPattern;
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block20: {
            this.typeDeclarationSet.clear();
            this.constructorDeclarationSet.clear();
            this.methodDeclarationSet.clear();
            this.fieldDeclarationSet.clear();
            this.typeReferenceSet.clear();
            this.constructorReferenceSet.clear();
            this.methodReferenceSet.clear();
            this.fieldReferenceSet.clear();
            this.stringSet.clear();
            this.superTypeNameSet.clear();
            this.descriptorSet.clear();
            try (InputStream inputStream = entry.getInputStream();){
                ClassReader classReader = new ClassReader(inputStream);
                classReader.accept((ClassVisitor)this.classIndexer, 7);
                for (String descriptor : this.descriptorSet) {
                    new SignatureReader(descriptor).accept((SignatureVisitor)this.signatureIndexer);
                }
                char[] buffer = new char[classReader.getMaxStringLength()];
                block14: for (int i = classReader.getItemCount() - 1; i > 0; --i) {
                    int startIndex = classReader.getItem(i);
                    if (startIndex == 0) continue;
                    int tag = classReader.readByte(startIndex - 1);
                    switch (tag) {
                        case 7: {
                            String className = classReader.readUTF8(startIndex, buffer);
                            if (className.startsWith("[")) {
                                new SignatureReader(className).acceptType((SignatureVisitor)this.signatureIndexer);
                                continue block14;
                            }
                            this.typeReferenceSet.add(className);
                            continue block14;
                        }
                        case 8: {
                            String str = classReader.readUTF8(startIndex, buffer);
                            this.stringSet.add(str);
                            continue block14;
                        }
                        case 9: {
                            int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                            int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                            tag = classReader.readByte(nameAndTypeIndex - 1);
                            if (tag != 12) continue block14;
                            String fieldName = classReader.readUTF8(nameAndTypeIndex, buffer);
                            this.fieldReferenceSet.add(fieldName);
                            continue block14;
                        }
                        case 10: 
                        case 11: {
                            String className;
                            int nameAndTypeItem = classReader.readUnsignedShort(startIndex + 2);
                            int nameAndTypeIndex = classReader.getItem(nameAndTypeItem);
                            tag = classReader.readByte(nameAndTypeIndex - 1);
                            if (tag != 12) continue block14;
                            String methodName = classReader.readUTF8(nameAndTypeIndex, buffer);
                            if ("<init>".equals(methodName)) {
                                int classItem = classReader.readUnsignedShort(startIndex);
                                int classIndex = classReader.getItem(classItem);
                                className = classReader.readUTF8(classIndex, buffer);
                                this.constructorReferenceSet.add(className);
                                continue block14;
                            }
                            this.methodReferenceSet.add(methodName);
                        }
                    }
                }
                String typeName = this.classIndexer.name;
                ClassFileIndexerProvider.addToIndexes(indexes, "typeDeclarations", this.typeDeclarationSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "constructorDeclarations", this.constructorDeclarationSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "methodDeclarations", this.methodDeclarationSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "fieldDeclarations", this.fieldDeclarationSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "typeReferences", this.typeReferenceSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "constructorReferences", this.constructorReferenceSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "methodReferences", this.methodReferenceSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "fieldReferences", this.fieldReferenceSet, entry);
                ClassFileIndexerProvider.addToIndexes(indexes, "strings", this.stringSet, entry);
                if (!this.superTypeNameSet.isEmpty()) {
                    Map<String, Collection> index = indexes.getIndex("subTypeNames");
                    for (String superTypeName : this.superTypeNameSet) {
                        index.get(superTypeName).add(typeName);
                    }
                }
                ProgressUtil.updateProgress(entry, getProgressFunction, setProgressFunction);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block20;
                throw new AssertionError();
            }
        }
    }

    protected class ClassIndexer
    extends ClassVisitor {
        private AnnotationIndexer annotationIndexer;
        private FieldIndexer fieldIndexer;
        private MethodIndexer methodIndexer;
        private String name;

        public ClassIndexer() {
            super(589824);
            this.annotationIndexer = new AnnotationIndexer();
            this.fieldIndexer = new FieldIndexer(this.annotationIndexer);
            this.methodIndexer = new MethodIndexer(this.annotationIndexer);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            ClassFileIndexerProvider.this.typeDeclarationSet.add(name);
            if (superName != null) {
                ClassFileIndexerProvider.this.superTypeNameSet.add(superName);
            }
            if (interfaces != null) {
                Collections.addAll(ClassFileIndexerProvider.this.superTypeNameSet, interfaces);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassFileIndexerProvider.this.fieldDeclarationSet.add(name);
            ClassFileIndexerProvider.this.descriptorSet.add(signature == null ? desc : signature);
            return this.fieldIndexer;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<init>".equals(name)) {
                ClassFileIndexerProvider.this.constructorDeclarationSet.add(this.name);
            } else if (!"<clinit>".equals(name)) {
                ClassFileIndexerProvider.this.methodDeclarationSet.add(name);
            }
            ClassFileIndexerProvider.this.descriptorSet.add(signature == null ? desc : signature);
            if (exceptions != null) {
                Collections.addAll(ClassFileIndexerProvider.this.typeReferenceSet, exceptions);
            }
            return this.methodIndexer;
        }
    }

    protected class SignatureIndexer
    extends SignatureVisitor {
        SignatureIndexer() {
            super(589824);
        }

        public void visitClassType(String name) {
            ClassFileIndexerProvider.this.typeReferenceSet.add(name);
        }
    }

    protected class MethodIndexer
    extends MethodVisitor {
        private AnnotationIndexer annotationIndexer;

        public MethodIndexer(AnnotationIndexer annotationIndexer) {
            super(589824);
            this.annotationIndexer = annotationIndexer;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected class FieldIndexer
    extends FieldVisitor {
        private AnnotationIndexer annotationIndexer;

        public FieldIndexer(AnnotationIndexer annotationIndexer) {
            super(589824);
            this.annotationIndexer = annotationIndexer;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this.annotationIndexer;
        }
    }

    protected class AnnotationIndexer
    extends AnnotationVisitor {
        public AnnotationIndexer() {
            super(589824);
        }

        public void visitEnum(String name, String desc, String value) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            ClassFileIndexerProvider.this.descriptorSet.add(desc);
            return this;
        }
    }
}

