/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.ZipFileLoaderProvider;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.LogPage;

public class LogFileLoaderProvider
extends ZipFileLoaderProvider {
    protected static final String[] EXTENSIONS = new String[]{"log"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "Log files (*.log)";
    }

    @Override
    public boolean accept(API api, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".log");
    }

    @Override
    public boolean load(API api, File file) {
        api.addPanel(file, file.getName(), null, "Location: " + file.getAbsolutePath(), new LogPage(api, file.toURI(), TextReader.getText(file)));
        return true;
    }
}

