/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.FileLoader;

public class FileLoaderService {
    protected static final FileLoaderService FILE_LOADER_SERVICE = new FileLoaderService();
    private final Collection<FileLoader> providers = ExtensionService.getInstance().load(FileLoader.class);
    private final Map<String, FileLoader> mapProviders = new HashMap<String, FileLoader>();

    public static FileLoaderService getInstance() {
        return FILE_LOADER_SERVICE;
    }

    protected FileLoaderService() {
        for (FileLoader provider : this.providers) {
            for (String extension : provider.getExtensions()) {
                this.mapProviders.put(extension, provider);
            }
        }
    }

    public FileLoader get(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        String extension = name.substring(lastDot + 1);
        return this.mapProviders.get(extension);
    }

    public Map<String, FileLoader> getMapProviders() {
        return this.mapProviders;
    }
}

