/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.TreeNodeData;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.spi.FileLoader;
import org.jd.gui.spi.PanelFactory;
import org.jd.gui.spi.TreeNodeFactory;

public abstract class AbstractFileLoaderProvider
implements FileLoader {
    protected <T extends JComponent> T load(API api, File file, Path rootPath) {
        Container container;
        ContainerEntry parentEntry = new ContainerEntry(file);
        ContainerFactory containerFactory = api.getContainerFactory(rootPath);
        if (containerFactory != null && (container = containerFactory.make(api, parentEntry, rootPath)) != null) {
            Object mainPanel;
            parentEntry.setChildren(container.getRoot().getChildren());
            PanelFactory panelFactory = api.getMainPanelFactory(container);
            if (panelFactory != null && (mainPanel = panelFactory.make(api, container)) != null) {
                TreeNodeFactory treeNodeFactory = api.getTreeNodeFactory(parentEntry);
                Object data = treeNodeFactory != null ? ((DefaultMutableTreeNode)treeNodeFactory.make(api, parentEntry)).getUserObject() : null;
                Icon icon = data instanceof TreeNodeData ? ((TreeNodeData)data).getIcon() : null;
                String location = file.getPath();
                api.addPanel(file, file.getName(), () -> icon, "Location: " + location, mainPanel);
                return mainPanel;
            }
        }
        return null;
    }

    protected static class ContainerEntry
    implements Container.Entry {
        protected static final Container PARENT_CONTAINER = new Container(){

            @Override
            public String getType() {
                return "generic";
            }

            @Override
            public Container.Entry getRoot() {
                return null;
            }
        };
        private Map<Container.EntryPath, Container.Entry> children = Collections.emptyMap();
        private File file;
        private URI uri;
        private String path;

        public ContainerEntry(File file) {
            this.file = file;
            this.uri = file.toURI();
            this.path = this.uri.getPath();
            if (this.path.endsWith("/")) {
                this.path = this.path.substring(0, this.path.length() - 1);
            }
        }

        @Override
        public Container getContainer() {
            return PARENT_CONTAINER;
        }

        @Override
        public Container.Entry getParent() {
            return null;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public long compressedLength() {
            return this.length();
        }

        @Override
        public Map<Container.EntryPath, Container.Entry> getChildren() {
            return this.children;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                return null;
            }
        }

        private void setChildren(Map<Container.EntryPath, Container.Entry> children) {
            this.children = children;
        }
    }
}

