/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.container;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.KarContainer;
import org.jd.gui.spi.ContainerFactory;

public class KarContainerFactoryProvider
implements ContainerFactory {
    @Override
    public String getType() {
        return "kar";
    }

    @Override
    public boolean accept(API api, Path rootPath) {
        if (rootPath.toUri().toString().toLowerCase().endsWith(".kar!/")) {
            return true;
        }
        try {
            return "file".equals(rootPath.getFileSystem().provider().getScheme()) && Files.exists(rootPath.resolve("repository"), new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return false;
        }
    }

    @Override
    public Container make(API api, Container.Entry parentEntry, Path rootPath) {
        return new KarContainer(api, parentEntry, rootPath);
    }
}

