/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.configuration;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.service.configuration.ConfigurationPersister;
import org.jd.gui.service.platform.PlatformService;

public class ConfigurationXmlPersisterProvider
implements ConfigurationPersister {
    private static final String NEW_LINE_2_TABS = "\n\t\t";
    private static final String NEW_LINE_3_TABS = "\n\t\t\t";
    protected static final File FILE = ConfigurationXmlPersisterProvider.getConfigFile();

    protected static File getConfigFile() {
        File roamingConfigHomeFile;
        String roamingConfigHome;
        File configFile;
        String configFilePath = System.getProperty("jd-gui.cfg");
        if (configFilePath != null && (configFile = new File(configFilePath)).exists()) {
            return configFile;
        }
        if (PlatformService.getInstance().isLinux()) {
            File xdgConfigHomeFile;
            String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
            if (xdgConfigHome != null && (xdgConfigHomeFile = new File(xdgConfigHome)).exists()) {
                return new File(xdgConfigHomeFile, "jd-gui.cfg");
            }
            File userConfigFile = new File(System.getProperty("user.home"), ".config");
            if (userConfigFile.exists()) {
                return new File(userConfigFile, "jd-gui.cfg");
            }
        } else if (PlatformService.getInstance().isWindows() && (roamingConfigHome = System.getenv("APPDATA")) != null && (roamingConfigHomeFile = new File(roamingConfigHome)).exists()) {
            return new File(roamingConfigHomeFile, "jd-gui.cfg");
        }
        return new File("jd-gui.cfg");
    }

    @Override
    public Configuration load() {
        Configuration config;
        block33: {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screenSize.width > 600 ? 600 : screenSize.width;
            int h = screenSize.height > 400 ? 400 : screenSize.height;
            int x = (screenSize.width - w) / 2;
            int y = (screenSize.height - h) / 2;
            config = new Configuration();
            config.setMainWindowLocation(new Point(x, y));
            config.setMainWindowSize(new Dimension(w, h));
            config.setMainWindowMaximize(false);
            String defaultLaf = System.getProperty("swing.defaultlaf");
            config.setLookAndFeel(defaultLaf != null ? defaultLaf : UIManager.getSystemLookAndFeelClassName());
            File recentSaveDirectory = new File(System.getProperty("user.dir"));
            config.setRecentLoadDirectory(recentSaveDirectory);
            config.setRecentSaveDirectory(recentSaveDirectory);
            if (FILE.exists()) {
                try (FileInputStream fis = new FileInputStream(FILE);){
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                    XMLStreamReader reader = factory.createXMLStreamReader(fis);
                    String name = "";
                    ArrayDeque<String> names = new ArrayDeque<String>();
                    List<File> recentFiles = new ArrayList<File>();
                    boolean maximize = false;
                    Map<String, String> preferences = config.getPreferences();
                    while (reader.hasNext()) {
                        block3 : switch (reader.next()) {
                            case 1: {
                                names.push(name);
                                name = String.join((CharSequence)"/", name, reader.getLocalName());
                                if ("/configuration/gui/mainWindow/location".equals(name)) {
                                    x = Integer.parseInt(reader.getAttributeValue(null, "x"));
                                    y = Integer.parseInt(reader.getAttributeValue(null, "y"));
                                    break;
                                }
                                if (!"/configuration/gui/mainWindow/size".equals(name)) break;
                                w = Integer.parseInt(reader.getAttributeValue(null, "w"));
                                h = Integer.parseInt(reader.getAttributeValue(null, "h"));
                                break;
                            }
                            case 2: {
                                name = (String)names.pop();
                                break;
                            }
                            case 4: {
                                switch (name) {
                                    case "/configuration/recentFilePaths/filePath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block3;
                                        recentFiles.add(file);
                                        break block3;
                                    }
                                    case "/configuration/recentDirectories/loadPath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block3;
                                        config.setRecentLoadDirectory(file);
                                        break block3;
                                    }
                                    case "/configuration/recentDirectories/savePath": {
                                        File file = new File(reader.getText().trim());
                                        if (!file.exists()) break block3;
                                        config.setRecentSaveDirectory(file);
                                        break block3;
                                    }
                                    case "/configuration/gui/lookAndFeel": {
                                        config.setLookAndFeel(reader.getText().trim());
                                        break block3;
                                    }
                                    case "/configuration/gui/mainWindow/maximize": {
                                        maximize = Boolean.parseBoolean(reader.getText().trim());
                                        break block3;
                                    }
                                }
                                if (!name.startsWith("/configuration/preferences/")) break;
                                String key = name.substring("/configuration/preferences/".length());
                                String text = reader.getText();
                                if (text.isBlank()) {
                                    preferences.put(key, text);
                                    break;
                                }
                                preferences.put(key, text.trim());
                            }
                        }
                    }
                    if (recentFiles.size() > 10) {
                        recentFiles = recentFiles.subList(0, 10);
                    }
                    config.setRecentFiles(recentFiles);
                    if (x >= 0 && y >= 0 && x + w < screenSize.width && y + h < screenSize.height) {
                        config.setMainWindowLocation(new Point(x, y));
                        config.setMainWindowSize(new Dimension(w, h));
                        config.setMainWindowMaximize(maximize);
                    }
                    reader.close();
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block33;
                    throw new AssertionError();
                }
            }
        }
        if (!config.getPreferences().containsKey("JdGuiPreferences.errorBackgroundColor")) {
            config.getPreferences().put("JdGuiPreferences.errorBackgroundColor", "0xFF6666");
        }
        config.getPreferences().put("JdGuiPreferences.jdCoreVersion", this.getJdCoreVersion());
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getJdCoreVersion() {
        try {
            Enumeration<URL> enumeration = ConfigurationXmlPersisterProvider.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                InputStream is = enumeration.nextElement().openStream();
                try {
                    String attribute = new Manifest(is).getMainAttributes().getValue("JD-Core-Version");
                    if (attribute == null) continue;
                    String string = attribute;
                    return string;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return "SNAPSHOT";
        }
        catch (IOException e) {
            if ($assertionsDisabled) return "SNAPSHOT";
            if (ExceptionUtil.printStackTrace((Throwable)e)) return "SNAPSHOT";
            throw new AssertionError();
        }
    }

    @Override
    public void save(Configuration configuration) {
        block9: {
            Point l = configuration.getMainWindowLocation();
            Dimension s = configuration.getMainWindowSize();
            try (FileOutputStream fos = new FileOutputStream(FILE);){
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
                writer.writeStartDocument();
                writer.writeCharacters("\n");
                writer.writeStartElement("configuration");
                writer.writeCharacters("\n\t");
                writer.writeStartElement("gui");
                writer.writeCharacters(NEW_LINE_2_TABS);
                writer.writeStartElement("mainWindow");
                writer.writeCharacters(NEW_LINE_3_TABS);
                writer.writeStartElement("location");
                writer.writeAttribute("x", String.valueOf(l.x));
                writer.writeAttribute("y", String.valueOf(l.y));
                writer.writeEndElement();
                writer.writeCharacters(NEW_LINE_3_TABS);
                writer.writeStartElement("size");
                writer.writeAttribute("w", String.valueOf(s.width));
                writer.writeAttribute("h", String.valueOf(s.height));
                writer.writeEndElement();
                writer.writeCharacters(NEW_LINE_3_TABS);
                writer.writeStartElement("maximize");
                writer.writeCharacters(String.valueOf(configuration.isMainWindowMaximize()));
                writer.writeEndElement();
                writer.writeCharacters(NEW_LINE_2_TABS);
                writer.writeEndElement();
                writer.writeCharacters(NEW_LINE_2_TABS);
                writer.writeStartElement("lookAndFeel");
                writer.writeCharacters(configuration.getLookAndFeel());
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("recentFilePaths");
                for (File file : configuration.getRecentFiles()) {
                    writer.writeCharacters(NEW_LINE_2_TABS);
                    writer.writeStartElement("filePath");
                    writer.writeCharacters(file.getAbsolutePath());
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("recentDirectories");
                writer.writeCharacters(NEW_LINE_2_TABS);
                writer.writeStartElement("loadPath");
                writer.writeCharacters(configuration.getRecentLoadDirectory().getAbsolutePath());
                writer.writeEndElement();
                writer.writeCharacters(NEW_LINE_2_TABS);
                writer.writeStartElement("savePath");
                writer.writeCharacters(configuration.getRecentSaveDirectory().getAbsolutePath());
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n\t");
                writer.writeStartElement("preferences");
                for (Map.Entry entry : configuration.getPreferences().entrySet()) {
                    writer.writeCharacters(NEW_LINE_2_TABS);
                    writer.writeStartElement((String)entry.getKey());
                    writer.writeCharacters((String)entry.getValue());
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n\t");
                writer.writeEndElement();
                writer.writeCharacters("\n");
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.close();
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
    }
}

