/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.actions;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphGotoReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphLoopReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphPreReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphReducer;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.actions.AbstractMethodAction;
import org.jd.gui.spi.ContextualActionsFactory;
import org.jd.gui.util.ImageUtil;
import org.jd.util.CFGViewer;

public class ShowControlFlowGraphContextualActionsFactory
implements ContextualActionsFactory {
    public static final int MODE_RAW = 0;
    public static final int MODE_GOTO_ONLY = 1;
    public static final int MODE_GOTO_AND_LOOP = 2;
    public static final int MODE_PRE_REDUCE = 3;

    @Override
    public Collection<Action> make(API api, Container.Entry entry, String fragment) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (entry.getPath().endsWith(".class")) {
            actions.add(new ShowControlFlowGraphAction(entry, fragment, null, 0));
            actions.add(new ShowControlFlowGraphAction(entry, fragment, null, 1));
            actions.add(new ShowControlFlowGraphAction(entry, fragment, null, 2));
            actions.add(new ShowControlFlowGraphAction(entry, fragment, null, 3));
            for (ControlFlowGraphReducer controlFlowGraphReducer : ControlFlowGraphReducer.getPreferredReducers()) {
                actions.add(new ShowControlFlowGraphAction(entry, fragment, controlFlowGraphReducer, 2));
            }
        }
        return actions;
    }

    public static class ShowControlFlowGraphAction
    extends AbstractMethodAction {
        private static final long serialVersionUID = 1L;
        protected static final ImageIcon ICON = new ImageIcon(ImageUtil.getImage("/net/sourceforge/plantuml/version/favicon.png"));
        private final transient ControlFlowGraphReducer controlFlowGraphReducer;
        private int mode;

        public ShowControlFlowGraphAction(Container.Entry entry, String fragment, ControlFlowGraphReducer controlFlowGraphReducer, int mode) {
            super(entry, fragment);
            this.controlFlowGraphReducer = controlFlowGraphReducer;
            this.mode = mode;
            if (controlFlowGraphReducer == null) {
                this.putValue("GroupNameKey", "Edit > ShowInitialControlFlowGraph");
                this.putValue("Name", "Show Initial Control Flow Graph " + this.getModeAsString());
            } else {
                String suffix = controlFlowGraphReducer.doPreReduce() ? " (with pre-reduce)" : " (no pre-reduce)";
                this.putValue("GroupNameKey", "Edit > ShowReducedControlFlowGraph" + suffix);
                this.putValue("Name", controlFlowGraphReducer.getLabel() + suffix);
            }
            this.putValue("SmallIcon", ICON);
        }

        private String getModeAsString() {
            return switch (this.mode) {
                case 0 -> "";
                case 1 -> "(Goto)";
                case 2 -> "(Goto, Loop)";
                case 3 -> "(Goto, Loop, Pre-Reduce)";
                default -> throw new IllegalArgumentException("Unexpected value: " + this.mode);
            };
        }

        @Override
        protected void methodAction(Method method, String className) {
            if ((method.getAccessFlags() & 0x400) != 0) {
                JOptionPane.showMessageDialog(null, "Method is abstract !", "ERROR", 0, ICON);
                return;
            }
            if (this.controlFlowGraphReducer == null) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraphMaker().make(method);
                switch (this.mode) {
                    case 1: {
                        ControlFlowGraphGotoReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        break;
                    }
                    case 2: {
                        ControlFlowGraphGotoReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        ControlFlowGraphLoopReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        break;
                    }
                    case 3: {
                        ControlFlowGraphGotoReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        ControlFlowGraphLoopReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        ControlFlowGraphPreReducer.reduce((ControlFlowGraph)controlFlowGraph);
                        break;
                    }
                }
                CFGViewer.showGraph(controlFlowGraph, className);
            } else {
                this.controlFlowGraphReducer.reduce(method);
                CFGViewer.showGraph(this.controlFlowGraphReducer.getControlFlowGraph(), className);
            }
        }
    }
}

