/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.bcel.classfile.Utility;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.actions.InvalidFormatException;
import org.jd.gui.spi.ContextualActionsFactory;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.util.ImageUtil;

public class CopyQualifiedNameContextualActionsFactory
implements ContextualActionsFactory {
    @Override
    public Collection<Action> make(API api, Container.Entry entry, String fragment) {
        return Arrays.asList(new CopyQualifiedNameAction(api, entry, fragment, true), new CopyQualifiedNameAction(api, entry, fragment, false));
    }

    public static class CopyQualifiedNameAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected static final ImageIcon ICON = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/cpyqual_menu.png"));
        private final transient API api;
        private final transient Container.Entry entry;
        private final String fragment;
        private final boolean qualified;

        public CopyQualifiedNameAction(API api, Container.Entry entry, String fragment, boolean qualified) {
            this.api = api;
            this.entry = entry;
            this.fragment = fragment;
            this.qualified = qualified;
            this.putValue("GroupNameKey", "Edit > CutCopyPaste");
            if (qualified) {
                this.putValue("Name", "Copy Qualified Name");
            } else {
                this.putValue("Name", "Copy Internal Name");
            }
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String rootPath;
            Type type;
            TypeFactory typeFactory = this.api.getTypeFactory(this.entry);
            if (typeFactory != null && (type = typeFactory.make(this.api, this.entry, this.fragment)) != null) {
                int dashIndex;
                StringBuilder sb;
                String displayPackageName = type.getDisplayPackageName();
                if (!this.qualified) {
                    displayPackageName = Utility.packageToPath((String)displayPackageName);
                }
                if ((sb = new StringBuilder(displayPackageName)).length() > 0) {
                    sb.append(this.qualified ? (char)'.' : '/');
                }
                sb.append(type.getDisplayTypeName());
                if (this.fragment != null && (dashIndex = this.fragment.indexOf(45)) != -1) {
                    int lastDashIndex = this.fragment.lastIndexOf(45);
                    if (dashIndex == lastDashIndex) {
                        throw new InvalidFormatException("fragment: " + this.fragment);
                    }
                    String name = this.fragment.substring(dashIndex + 1, lastDashIndex);
                    String descriptor = this.fragment.substring(lastDashIndex + 1);
                    if (descriptor.startsWith("(")) {
                        for (Type.Method method : type.getMethods()) {
                            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
                            sb.append('.').append(method.getDisplayName());
                            break;
                        }
                    } else {
                        for (Type.Field field : type.getFields()) {
                            if (!field.getName().equals(name) || !field.getDescriptor().equals(descriptor)) continue;
                            sb.append('.').append(field.getDisplayName());
                            break;
                        }
                    }
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
                return;
            }
            String path = this.entry.getUri().getPath();
            String qualifiedName = path.substring((rootPath = this.entry.getContainer().getRoot().getUri().getPath()).length());
            if (qualifiedName.endsWith(".class")) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 6);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(qualifiedName), null);
        }
    }
}

