/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.ContextualActionsFactory;

public class ContextualActionsFactoryService {
    protected static final ContextualActionsFactoryService CONTEXTUAL_ACTIONS_FACTORY_SERVICE = new ContextualActionsFactoryService();
    private final Collection<ContextualActionsFactory> providers = ExtensionService.getInstance().load(ContextualActionsFactory.class);

    public static ContextualActionsFactoryService getInstance() {
        return CONTEXTUAL_ACTIONS_FACTORY_SERVICE;
    }

    private static String getActionName(Action a) {
        String name = (String)a.getValue("Name");
        if (name == null) {
            name = "";
        }
        return name;
    }

    public Collection<Action> get(API api, Container.Entry entry, String fragment) {
        HashMap<String, List> mapActions = new HashMap<String, List>();
        for (ContextualActionsFactory provider : this.providers) {
            Collection<Action> actions = provider.make(api, entry, fragment);
            for (Action action : actions) {
                String groupName = (String)action.getValue("GroupNameKey");
                mapActions.computeIfAbsent(groupName, k -> new ArrayList()).add(action);
            }
        }
        if (!mapActions.isEmpty()) {
            ArrayList<Action> result = new ArrayList<Action>();
            ArrayList groupNames = new ArrayList(mapActions.keySet());
            Collections.sort(groupNames);
            for (String groupName : groupNames) {
                if (!result.isEmpty()) {
                    result.add(null);
                }
                List actions = (List)mapActions.get(groupName);
                Collections.sort(actions, Comparator.comparing(ContextualActionsFactoryService::getActionName));
                result.addAll(actions);
            }
            return result;
        }
        return Collections.emptyList();
    }
}

