/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.model.container;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.ContainerEntryComparator;
import org.jd.gui.model.container.entry.path.SimpleEntryPath;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.util.TempFile;
import org.jd.gui.util.index.IndexesUtil;

public class GenericContainer
implements Container,
Closeable {
    protected static final long TIMESTAMP = System.currentTimeMillis();
    private static final AtomicLong tmpFileCounter = new AtomicLong(0L);
    private final API api;
    private final int rootNameCount;
    private final Container.Entry root;
    private ZipFile zipFile;

    public GenericContainer(API api, Container.Entry parentEntry, Path rootPath) {
        this.api = api;
        this.rootNameCount = rootPath.getNameCount();
        this.root = this.makeRootEntry(parentEntry, rootPath);
        this.zipFile = GenericContainer.makeZipFile(parentEntry);
    }

    private static ZipFile makeZipFile(Container.Entry parentEntry) {
        block3: {
            try {
                File file = new File(parentEntry.getPath());
                if (file.exists()) {
                    return new ZipFile(file);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                throw new AssertionError();
            }
        }
        return null;
    }

    private Entry makeRootEntry(Container.Entry parentEntry, Path rootPath) {
        try {
            URI uri = parentEntry.getUri();
            return new Entry(parentEntry, rootPath, new URI(uri.getScheme(), uri.getHost(), uri.getPath() + "!/", null)){

                @Override
                public Entry newChildEntry(Path fsPath) {
                    return new Entry(this.getParent(), fsPath, null);
                }
            };
        }
        catch (URISyntaxException e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public String getType() {
        return "generic";
    }

    @Override
    public Container.Entry getRoot() {
        return this.root;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.zipFile);
        this.zipFile = null;
    }

    protected class Entry
    implements Container.Entry {
        private final Container.Entry parent;
        private final Path fsPath;
        private String strPath;
        private URI uri;
        private Boolean isDirectory;
        private Map<Container.EntryPath, Container.Entry> children;

        public Entry(Container.Entry parent, Path fsPath, URI uri) {
            this.parent = parent;
            this.fsPath = fsPath;
            this.strPath = null;
            this.uri = uri;
            this.isDirectory = null;
            this.children = null;
        }

        public Entry newChildEntry(Path fsPath) {
            return new Entry(this, fsPath, null);
        }

        @Override
        public Container getContainer() {
            return GenericContainer.this;
        }

        @Override
        public Container.Entry getParent() {
            return this.parent;
        }

        @Override
        public URI getUri() {
            block3: {
                if (this.uri == null) {
                    try {
                        URI rootUri = GenericContainer.this.root.getUri();
                        this.uri = new URI(rootUri.getScheme(), rootUri.getHost(), rootUri.getPath() + this.getPath(), null);
                    }
                    catch (URISyntaxException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                        throw new AssertionError();
                    }
                }
            }
            return this.uri;
        }

        @Override
        public String getPath() {
            if (this.strPath == null) {
                int nameCount = this.fsPath.getNameCount();
                if (GenericContainer.this.rootNameCount == nameCount) {
                    this.strPath = "";
                } else {
                    this.strPath = this.fsPath.subpath(GenericContainer.this.rootNameCount, nameCount).toString().replace(this.fsPath.getFileSystem().getSeparator(), "/");
                    int strPathLength = this.strPath.length();
                    if (strPathLength > 0 && this.strPath.charAt(strPathLength - 1) == '/') {
                        this.strPath = this.strPath.substring(0, strPathLength - 1);
                    }
                }
            }
            return this.strPath;
        }

        @Override
        public boolean isDirectory() {
            if (this.isDirectory == null) {
                this.isDirectory = Files.isDirectory(this.fsPath, new LinkOption[0]);
            }
            return this.isDirectory;
        }

        @Override
        public long length() {
            try {
                return Files.size(this.fsPath);
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                return -1L;
            }
        }

        @Override
        public long compressedLength() {
            if (GenericContainer.this.zipFile == null) {
                return this.length();
            }
            ZipEntry zipEntry = GenericContainer.this.zipFile.getEntry(this.strPath);
            return IndexesUtil.entryImpactBytes(zipEntry);
        }

        @Override
        public InputStream getInputStream() {
            try {
                return Files.newInputStream(this.fsPath, new OpenOption[0]);
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                return null;
            }
        }

        @Override
        public Map<Container.EntryPath, Container.Entry> getChildren() {
            block3: {
                if (this.children == null) {
                    try {
                        this.children = Files.isDirectory(this.fsPath, new LinkOption[0]) ? this.loadChildrenFromDirectoryEntry() : this.loadChildrenFromFileEntry();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                        throw new AssertionError();
                    }
                }
            }
            return this.children;
        }

        protected NavigableMap<Container.EntryPath, Container.Entry> loadChildrenFromDirectoryEntry() throws IOException {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.fsPath);){
                TreeMap<Container.EntryPath, Entry> sortedChildren = new TreeMap<Container.EntryPath, Entry>(ContainerEntryComparator.COMPARATOR);
                int parentNameCount = this.fsPath.getNameCount();
                for (Path subPath : stream) {
                    if (subPath.getNameCount() <= parentNameCount) continue;
                    Entry newChildEntry = this.newChildEntry(subPath);
                    SimpleEntryPath newChildEntryPath = new SimpleEntryPath(newChildEntry.getPath(), newChildEntry.isDirectory());
                    sortedChildren.put(newChildEntryPath, newChildEntry);
                }
                NavigableMap navigableMap = Collections.unmodifiableNavigableMap(sortedChildren);
                return navigableMap;
            }
        }

        protected Map<Container.EntryPath, Container.Entry> loadChildrenFromFileEntry() throws IOException {
            StringBuilder suffix = new StringBuilder(".").append(TIMESTAMP).append('.').append(tmpFileCounter.getAndIncrement()).append('.').append(this.fsPath.getFileName().toString());
            try (TempFile tmpFile = new TempFile(suffix.toString());){
                Container container;
                Path rootPath;
                ContainerFactory containerFactory;
                Path tmpPath = Paths.get(tmpFile.toURI());
                Files.copy(this.fsPath, tmpPath, new CopyOption[0]);
                FileSystem subFileSystem = FileSystems.newFileSystem(tmpPath, (ClassLoader)null);
                Iterator<Path> rootDirectories = subFileSystem.getRootDirectories().iterator();
                if (rootDirectories.hasNext() && (containerFactory = GenericContainer.this.api.getContainerFactory(rootPath = rootDirectories.next())) != null && (container = containerFactory.make(GenericContainer.this.api, this, rootPath)) != null) {
                    Map<Container.EntryPath, Container.Entry> map = container.getRoot().getChildren();
                    return map;
                }
            }
            return Collections.emptyMap();
        }
    }
}

