/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.model.container;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.entry.path.SimpleEntryPath;

public class DelegatingFilterContainer
implements Container {
    protected static final URI DEFAULT_ROOT_URI = URI.create("file:.");
    private final Container container;
    private final DelegatedEntry root;
    private final Set<URI> validEntries = new HashSet<URI>();
    private final Map<URI, DelegatedEntry> uriToDelegatedEntry = new HashMap<URI, DelegatedEntry>();
    private final Map<URI, DelegatedContainer> uriToDelegatedContainer = new HashMap<URI, DelegatedContainer>();

    public DelegatingFilterContainer(Container container, Collection<Container.Entry> entries) {
        this.container = container;
        this.root = this.getDelegatedEntry(container.getRoot());
        Iterator<Container.Entry> iterator = entries.iterator();
        while (iterator.hasNext()) {
            for (Container.Entry entry = iterator.next(); entry != null && !this.validEntries.contains(entry.getUri()); entry = entry.getParent()) {
                this.validEntries.add(entry.getUri());
            }
        }
    }

    @Override
    public String getType() {
        return this.container.getType();
    }

    @Override
    public Container.Entry getRoot() {
        return this.root;
    }

    public Container.Entry getEntry(URI uri) {
        return this.uriToDelegatedEntry.get(uri);
    }

    public Set<URI> getUris() {
        return this.validEntries;
    }

    protected DelegatedEntry getDelegatedEntry(Container.Entry entry) {
        URI uri = entry.getUri();
        return this.uriToDelegatedEntry.computeIfAbsent(uri, k -> new DelegatedEntry(entry));
    }

    protected DelegatedContainer getDelegatedContainer(Container container) {
        Container.Entry localRoot = container.getRoot();
        URI uri = localRoot == null ? DEFAULT_ROOT_URI : localRoot.getUri();
        return this.uriToDelegatedContainer.computeIfAbsent(uri, k -> new DelegatedContainer(container));
    }

    protected class DelegatedEntry
    implements Container.Entry,
    Comparable<DelegatedEntry> {
        private final Container.Entry entry;
        private Map<Container.EntryPath, Container.Entry> children;

        public DelegatedEntry(Container.Entry entry) {
            this.entry = entry;
        }

        @Override
        public Container getContainer() {
            return DelegatingFilterContainer.this.getDelegatedContainer(this.entry.getContainer());
        }

        @Override
        public Container.Entry getParent() {
            return DelegatingFilterContainer.this.getDelegatedEntry(this.entry.getParent());
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public String getPath() {
            return this.entry.getPath();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public long length() {
            return this.entry.length();
        }

        @Override
        public long compressedLength() {
            return this.entry.compressedLength();
        }

        @Override
        public InputStream getInputStream() {
            return this.entry.getInputStream();
        }

        @Override
        public Map<Container.EntryPath, Container.Entry> getChildren() {
            if (this.children == null) {
                this.children = this.entry.getChildren().values().stream().filter(child -> DelegatingFilterContainer.this.validEntries.contains(child.getUri())).collect(Collectors.toMap(SimpleEntryPath::new, this::getDelegEntry));
            }
            return this.children;
        }

        private DelegatedEntry getDelegEntry(Container.Entry entry) {
            return DelegatingFilterContainer.this.getDelegatedEntry(entry);
        }

        @Override
        public int compareTo(DelegatedEntry other) {
            if (this.entry.isDirectory()) {
                if (!other.isDirectory()) {
                    return -1;
                }
            } else if (other.isDirectory()) {
                return 1;
            }
            return this.entry.getPath().compareTo(other.getPath());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.compareTo((DelegatedEntry)obj) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.entry.isDirectory(), this.entry.getPath());
        }
    }

    protected class DelegatedContainer
    implements Container {
        private final Container container;

        public DelegatedContainer(Container container) {
            this.container = container;
        }

        @Override
        public String getType() {
            return this.container.getType();
        }

        @Override
        public Container.Entry getRoot() {
            return DelegatingFilterContainer.this.getDelegatedEntry(this.container.getRoot());
        }
    }
}

