/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import de.cismet.custom.visualdiff.DiffPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jd.core.ClassUtil;
import jd.core.DecompilationResult;
import org.apache.commons.io.IOUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.model.container.DelegatingFilterContainer;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.loader.LoaderUtils;
import org.jd.gui.view.SelectLocationView;

public class SelectLocationController {
    private final API api;
    private final SelectLocationView selectLocationView;

    public SelectLocationController(API api, JFrame mainFrame) {
        this.api = api;
        this.selectLocationView = new SelectLocationView(api, mainFrame);
    }

    /*
     * WARNING - void declaration
     */
    public void show(Point location, Collection<Container.Entry> entries, Consumer<Container.Entry> selectedLocationCallback, Runnable closeCallback) {
        HashMap<Container, List> map = new HashMap<Container, List>();
        for (Container.Entry entry : entries) {
            void var8_10;
            Container parentContainer;
            Container container = entry.getContainer();
            while ((parentContainer = var8_10.getRoot().getParent().getContainer()).getRoot() != null) {
                Container container2 = parentContainer;
            }
            map.computeIfAbsent((Container)var8_10, c -> new ArrayList()).add(entry);
        }
        HashSet<DelegatingFilterContainer> delegatingFilterContainers = new HashSet<DelegatingFilterContainer>();
        for (Map.Entry entry : map.entrySet()) {
            Container container = (Container)entry.getKey();
            delegatingFilterContainers.add(new DelegatingFilterContainer(container, this.getOuterEntries((Collection)entry.getValue())));
        }
        Consumer<URI> consumer = uri -> this.onLocationSelected((Set<DelegatingFilterContainer>)delegatingFilterContainers, (URI)uri, selectedLocationCallback);
        Container.Entry[] entryArray = (Container.Entry[])entries.toArray(Container.Entry[]::new);
        String fileNameLeft = new File(entryArray[0].getContainer().getRoot().getParent().getUri()).getName();
        String fileNameRight = new File(entryArray[1].getContainer().getRoot().getParent().getUri()).getName();
        String className = new File(entryArray[0].getUri()).getName();
        ImageIcon icon = new ImageIcon(ImageUtil.getImage("/org/jd/gui/images/jd_icon_64.png"));
        String message = "Compare class " + className + " in files " + fileNameLeft + " and " + fileNameRight + "?";
        if (entries.size() == 2 && JOptionPane.showConfirmDialog(null, message, "Compare JAVA source files ?", 0, 3, icon) == 0) {
            JFrame diffFrame = new JFrame("Comparison view for class " + className);
            ImageUtil.addJDIconsToFrame(diffFrame);
            DiffPanel diffPanel = new DiffPanel(diffFrame);
            try {
                String contentLeft = this.getContent(entryArray[0]);
                String contentRight = this.getContent(entryArray[1]);
                diffPanel.setLeftAndRight(contentLeft, "text/x-java", fileNameLeft, contentRight, "text/x-java", fileNameRight);
                diffFrame.getContentPane().add((Component)diffPanel);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                diffFrame.setLocation((int)Math.round(screenSize.getWidth() / 6.0), (int)Math.round(screenSize.getHeight() / 6.0));
                diffFrame.setSize((int)Math.round(screenSize.getWidth() / 1.5), (int)Math.round(screenSize.getHeight() / 1.5));
                diffFrame.setVisible(true);
            }
            catch (Exception e) {
                ExceptionUtil.printStackTrace((Throwable)e);
            }
        } else {
            this.selectLocationView.show(location, delegatingFilterContainers, entries.size(), consumer, closeCallback);
        }
    }

    private String getContent(Container.Entry entry) throws IOException, TransformationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (entry.getPath().endsWith(".class")) {
            Map<String, String> preferences = this.api.getPreferences();
            preferences.put("ClassFileSaverPreferences.writeLineNumbers", "false");
            preferences.put("ClassFileSaverPreferences.realignLineNumbers", "true");
            ContainerLoader containerLoader = new ContainerLoader(entry);
            String decompileEngine = preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1");
            Loader apiLoader = LoaderUtils.createLoader(preferences, containerLoader, entry);
            String entryInternalName = ClassUtil.getInternalName((String)entry.getPath());
            DecompilationResult decompilationResult = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)decompileEngine);
            return decompilationResult.getDecompiledOutput();
        }
        try (InputStream in = entry.getInputStream();){
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    protected Collection<Container.Entry> getOuterEntries(Collection<Container.Entry> entries) {
        HashMap<Container.Entry, Container.Entry> innerTypeEntryToOuterTypeEntry = new HashMap<Container.Entry, Container.Entry>();
        HashSet<Container.Entry> outerEntriesSet = new HashSet<Container.Entry>();
        for (Container.Entry entry : entries) {
            Type type;
            Container.Entry outerTypeEntry = null;
            TypeFactory factory = TypeFactoryService.getInstance().get(entry);
            if (factory != null && (type = factory.make(this.api, entry, null)) != null && type.getOuterName() != null && (outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry)) == null) {
                HashMap<String, Container.Entry> typeNameToEntry = new HashMap<String, Container.Entry>();
                HashMap<String, String> innerTypeNameToOuterTypeName = new HashMap<String, String>();
                for (Container.Entry entry2 : entry.getParent().getChildren().values()) {
                    factory = TypeFactoryService.getInstance().get(entry2);
                    if (factory == null || (type = factory.make(this.api, entry2, null)) == null) continue;
                    typeNameToEntry.put(type.getName(), entry2);
                    if (type.getOuterName() == null) continue;
                    innerTypeNameToOuterTypeName.put(type.getName(), type.getOuterName());
                }
                for (Map.Entry entry3 : innerTypeNameToOuterTypeName.entrySet()) {
                    String typeName;
                    Container.Entry innerTypeEntry = (Container.Entry)typeNameToEntry.get(entry3.getKey());
                    if (innerTypeEntry == null) continue;
                    String outerTypeName = (String)entry3.getValue();
                    while ((typeName = (String)innerTypeNameToOuterTypeName.get(outerTypeName)) != null) {
                        outerTypeName = typeName;
                    }
                    outerTypeEntry = (Container.Entry)typeNameToEntry.get(outerTypeName);
                    if (outerTypeEntry == null) continue;
                    innerTypeEntryToOuterTypeEntry.put(innerTypeEntry, outerTypeEntry);
                }
                outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry);
            }
            if (outerTypeEntry != null) {
                outerEntriesSet.add(outerTypeEntry);
                continue;
            }
            outerEntriesSet.add(entry);
        }
        ArrayList<Container.Entry> result = new ArrayList<Container.Entry>(outerEntriesSet);
        result.sort(Comparator.comparing(Container.EntryPath::getPath));
        return result;
    }

    protected void onLocationSelected(Set<DelegatingFilterContainer> delegatingFilterContainers, URI uri, Consumer<Container.Entry> selectedLocationCallback) {
        DelegatingFilterContainer container;
        Container.Entry entry = null;
        Iterator<DelegatingFilterContainer> iterator = delegatingFilterContainers.iterator();
        while (iterator.hasNext() && (entry = (container = iterator.next()).getEntry(uri)) == null) {
        }
        if (entry != null) {
            selectedLocationCallback.accept(entry);
        }
    }
}

