/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.Type;
import org.jd.gui.model.container.DelegatingFilterContainer;
import org.jd.gui.model.container.entry.path.FileEntryPath;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.util.function.TriConsumer;
import org.jd.gui.view.SearchInConstantPoolsView;
import org.jd.util.LRUCache;

public class SearchInConstantPoolsController
implements IndexesChangeListener {
    protected static final int CACHE_MAX_ENTRIES = 900;
    private final API api;
    private final ScheduledExecutorService executor;
    private final SearchInConstantPoolsView searchInConstantPoolsView;
    private final Map<String, Map<String, Collection>> cache;
    private final Set<DelegatingFilterContainer> delegatingFilterContainers = new HashSet<DelegatingFilterContainer>();
    private Collection<Future<Indexes>> collectionOfFutureIndexes;
    private Consumer<URI> openCallback;
    private long indexesHashCode;

    public SearchInConstantPoolsController(API api, ScheduledExecutorService executor, JFrame mainFrame) {
        this.api = api;
        this.executor = executor;
        ObjIntConsumer<String> changedPatternCallback = this::updateTree;
        TriConsumer<URI, String, Integer> selectedTypeCallback = this::onTypeSelected;
        this.searchInConstantPoolsView = new SearchInConstantPoolsView(api, mainFrame, changedPatternCallback, selectedTypeCallback);
        this.cache = new LRUCache<String, Map<String, Collection>>(900);
    }

    public void show(Collection<Future<Indexes>> collectionOfFutureIndexes, Consumer<URI> openCallback) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        this.openCallback = openCallback;
        long hashCode = collectionOfFutureIndexes.hashCode();
        if (hashCode != this.indexesHashCode) {
            this.updateTree(this.searchInConstantPoolsView.getPattern(), this.searchInConstantPoolsView.getFlags());
            this.indexesHashCode = hashCode;
        }
        this.searchInConstantPoolsView.show();
    }

    protected void updateTree(String pattern, int flags) {
        this.delegatingFilterContainers.clear();
        this.executor.execute(() -> {
            int matchingTypeCount;
            block7: {
                this.searchInConstantPoolsView.showWaitCursor();
                matchingTypeCount = 0;
                int patternLength = pattern.length();
                if (patternLength > 0) {
                    try {
                        for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                            if (!futureIndexes.isDone()) continue;
                            Indexes indexes = futureIndexes.get();
                            Set<Container.Entry> matchingEntries = new HashSet<Container.Entry>();
                            this.filter(indexes, pattern, flags, matchingEntries);
                            if (matchingEntries.isEmpty()) continue;
                            Container.Entry parentEntry = (Container.Entry)matchingEntries.iterator().next();
                            Container container = null;
                            while (parentEntry.getContainer().getRoot() != null) {
                                container = parentEntry.getContainer();
                                parentEntry = container.getRoot().getParent();
                            }
                            matchingEntries = this.getOuterEntries(matchingEntries);
                            matchingTypeCount += matchingEntries.size();
                            this.delegatingFilterContainers.add(new DelegatingFilterContainer(container, matchingEntries));
                        }
                    }
                    catch (InterruptedException e) {
                        assert (ExceptionUtil.printStackTrace((Throwable)e));
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                        throw new AssertionError();
                    }
                }
            }
            int count = matchingTypeCount;
            this.searchInConstantPoolsView.hideWaitCursor();
            this.searchInConstantPoolsView.updateTree(this.delegatingFilterContainers, count);
        });
    }

    protected Set<Container.Entry> getOuterEntries(Set<Container.Entry> matchingEntries) {
        HashMap<Container.Entry, Container.Entry> innerTypeEntryToOuterTypeEntry = new HashMap<Container.Entry, Container.Entry>();
        HashSet<Container.Entry> matchingOuterEntriesSet = new HashSet<Container.Entry>();
        for (Container.Entry entry : matchingEntries) {
            TypeFactory typeFactory = TypeFactoryService.getInstance().get(entry);
            if (typeFactory != null) {
                Type type = typeFactory.make(this.api, entry, null);
                if (type != null && type.getOuterName() != null) {
                    Container.Entry outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry);
                    if (outerTypeEntry == null) {
                        HashMap<String, Container.Entry> typeNameToEntry = new HashMap<String, Container.Entry>();
                        HashMap<String, String> innerTypeNameToOuterTypeName = new HashMap<String, String>();
                        for (Container.Entry e : entry.getParent().getChildren().values()) {
                            typeFactory = TypeFactoryService.getInstance().get(e);
                            if (typeFactory == null || (type = typeFactory.make(this.api, e, null)) == null) continue;
                            typeNameToEntry.put(type.getName(), e);
                            if (type.getOuterName() == null) continue;
                            innerTypeNameToOuterTypeName.put(type.getName(), type.getOuterName());
                        }
                        for (Map.Entry e : innerTypeNameToOuterTypeName.entrySet()) {
                            String typeName;
                            Container.Entry innerTypeEntry = (Container.Entry)typeNameToEntry.get(e.getKey());
                            if (innerTypeEntry == null) continue;
                            String outerTypeName = (String)e.getValue();
                            while ((typeName = (String)innerTypeNameToOuterTypeName.get(outerTypeName)) != null) {
                                outerTypeName = typeName;
                            }
                            outerTypeEntry = (Container.Entry)typeNameToEntry.get(outerTypeName);
                            if (outerTypeEntry == null) continue;
                            innerTypeEntryToOuterTypeEntry.put(innerTypeEntry, outerTypeEntry);
                        }
                        outerTypeEntry = (Container.Entry)innerTypeEntryToOuterTypeEntry.get(entry);
                        if (outerTypeEntry == null) {
                            outerTypeEntry = entry;
                        }
                    }
                    matchingOuterEntriesSet.add(outerTypeEntry);
                    continue;
                }
                String path = entry.getPath();
                int idx = path.indexOf(36);
                if (idx != -1 && path.endsWith(".class")) {
                    FileEntryPath topLevelTypePath = new FileEntryPath(path.substring(0, idx) + ".class");
                    matchingOuterEntriesSet.add(entry.getParent().getChildren().get(topLevelTypePath));
                    continue;
                }
                matchingOuterEntriesSet.add(entry);
                continue;
            }
            matchingOuterEntriesSet.add(entry);
        }
        return matchingOuterEntriesSet;
    }

    protected void filter(Indexes indexes, String pattern, int flags, Set<Container.Entry> matchingEntries) {
        boolean references;
        boolean declarations = (flags & 0x40) != 0;
        boolean bl = references = (flags & 0x80) != 0;
        if ((flags & 1) != 0) {
            if (declarations) {
                this.match(indexes, "typeDeclarations", pattern, SearchInConstantPoolsController::matchTypeEntriesWithChar, SearchInConstantPoolsController::matchTypeEntriesWithString, matchingEntries);
            }
            if (references) {
                this.match(indexes, "typeReferences", pattern, SearchInConstantPoolsController::matchTypeEntriesWithChar, SearchInConstantPoolsController::matchTypeEntriesWithString, matchingEntries);
            }
        }
        if ((flags & 2) != 0) {
            if (declarations) {
                this.match(indexes, "constructorDeclarations", pattern, SearchInConstantPoolsController::matchTypeEntriesWithChar, SearchInConstantPoolsController::matchTypeEntriesWithString, matchingEntries);
            }
            if (references) {
                this.match(indexes, "constructorReferences", pattern, SearchInConstantPoolsController::matchTypeEntriesWithChar, SearchInConstantPoolsController::matchTypeEntriesWithString, matchingEntries);
            }
        }
        if ((flags & 4) != 0) {
            if (declarations) {
                this.match(indexes, "methodDeclarations", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
            if (references) {
                this.match(indexes, "methodReferences", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
        }
        if ((flags & 8) != 0) {
            if (declarations) {
                this.match(indexes, "fieldDeclarations", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
            if (references) {
                this.match(indexes, "fieldReferences", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
        }
        if ((flags & 0x10) != 0 && (declarations || references)) {
            this.match(indexes, "strings", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
        }
        if ((flags & 0x20) != 0) {
            if (declarations) {
                this.match(indexes, "javaModuleDeclarations", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
            if (references) {
                this.match(indexes, "javaModuleReferences", pattern, SearchInConstantPoolsController::matchWithChar, SearchInConstantPoolsController::matchWithString, matchingEntries);
            }
        }
    }

    protected void match(Indexes indexes, String indexName, String pattern, BiFunction<Character, Map<String, Collection>, Map<String, Collection>> matchWithCharFunction, BiFunction<String, Map<String, Collection>, Map<String, Collection>> matchWithStringFunction, Set<Container.Entry> matchingEntries) {
        String lastKey;
        Map<String, Collection> lastMatchedTypes;
        String key;
        Map matchedEntries;
        int patternLength = pattern.length();
        if (patternLength > 0 && (matchedEntries = this.cache.computeIfAbsent(key = indexes.hashCode() + "***" + indexName + "***" + pattern, arg_0 -> SearchInConstantPoolsController.lambda$match$1(indexes, indexName, patternLength, matchWithCharFunction, pattern, lastMatchedTypes = this.cache.get(lastKey = key.substring(0, key.length() - 1)), matchWithStringFunction, arg_0))) != null) {
            for (Collection entries : matchedEntries.values()) {
                matchingEntries.addAll(entries);
            }
        }
    }

    protected static Map<String, Collection> matchTypeEntriesWithChar(char c, Map<String, Collection> index) {
        if (c == '*' || c == '?') {
            return index;
        }
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (Map.Entry<String, Collection> entry : index.entrySet()) {
            int lastTypeNameSeparatorIndex;
            String typeName = entry.getKey();
            int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
            int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1);
            if (lastIndex >= typeName.length() || typeName.charAt(lastIndex) != c) continue;
            map.put(typeName, entry.getValue());
        }
        return map;
    }

    protected static Map<String, Collection> matchTypeEntriesWithString(String pattern, Map<String, Collection> index) {
        Pattern p = SearchInConstantPoolsController.createPattern(pattern);
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (Map.Entry<String, Collection> entry : index.entrySet()) {
            int lastTypeNameSeparatorIndex;
            int lastPackageSeparatorIndex;
            int lastIndex;
            String typeName = entry.getKey();
            if (!p.matcher(typeName.substring(lastIndex = Math.max(lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1, lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1))).matches()) continue;
            map.put(typeName, entry.getValue());
        }
        return map;
    }

    protected static Map<String, Collection> matchWithChar(char c, Map<String, Collection> index) {
        if (c == '*' || c == '?') {
            return index;
        }
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (Map.Entry<String, Collection> entry : index.entrySet()) {
            String key = entry.getKey();
            if (key.isEmpty() || key.charAt(0) != c) continue;
            map.put(key, entry.getValue());
        }
        return map;
    }

    protected static Map<String, Collection> matchWithString(String pattern, Map<String, Collection> index) {
        Pattern p = SearchInConstantPoolsController.createPattern(pattern);
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        for (Map.Entry<String, Collection> entry : index.entrySet()) {
            String key = entry.getKey();
            if (!p.matcher(key).matches()) continue;
            map.put(key, entry.getValue());
        }
        return map;
    }

    protected static Pattern createPattern(String pattern) {
        int patternLength = pattern.length();
        StringBuilder sbPattern = new StringBuilder(patternLength * 2);
        block5: for (int i = 0; i < patternLength; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    sbPattern.append(".*");
                    continue block5;
                }
                case '?': {
                    sbPattern.append('.');
                    continue block5;
                }
                case '.': {
                    sbPattern.append("\\.");
                    continue block5;
                }
                default: {
                    sbPattern.append(c);
                }
            }
        }
        sbPattern.append(".*");
        return Pattern.compile(sbPattern.toString());
    }

    protected void onTypeSelected(URI uri, String pattern, int flags) {
        block12: {
            DelegatingFilterContainer container;
            Container.Entry entry = null;
            Iterator<DelegatingFilterContainer> iterator = this.delegatingFilterContainers.iterator();
            while (iterator.hasNext() && (entry = (container = iterator.next()).getEntry(uri)) == null) {
            }
            if (entry != null) {
                StringBuilder sbPattern = new StringBuilder(200 + pattern.length());
                sbPattern.append("highlightPattern=");
                sbPattern.append(pattern);
                sbPattern.append("&highlightFlags=");
                if ((flags & 0x40) != 0) {
                    sbPattern.append('d');
                }
                if ((flags & 0x80) != 0) {
                    sbPattern.append('r');
                }
                if ((flags & 1) != 0) {
                    sbPattern.append('t');
                }
                if ((flags & 2) != 0) {
                    sbPattern.append('c');
                }
                if ((flags & 4) != 0) {
                    sbPattern.append('m');
                }
                if ((flags & 8) != 0) {
                    sbPattern.append('f');
                }
                if ((flags & 0x10) != 0) {
                    sbPattern.append('s');
                }
                if ((flags & 0x20) != 0) {
                    sbPattern.append('M');
                }
                String query = sbPattern.toString();
                URI u = entry.getUri();
                try {
                    this.openCallback.accept(new URI(u.getScheme(), u.getHost(), u.getPath(), query, null));
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block12;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        if (this.searchInConstantPoolsView.isVisible()) {
            this.collectionOfFutureIndexes = collectionOfFutureIndexes;
            this.updateTree(this.searchInConstantPoolsView.getPattern(), this.searchInConstantPoolsView.getFlags());
        }
    }

    private static /* synthetic */ Map lambda$match$1(Indexes indexes, String indexName, int patternLength, BiFunction matchWithCharFunction, String pattern, Map lastMatchedTypes, BiFunction matchWithStringFunction, String k) {
        Map<String, Collection> index = indexes.getIndex(indexName);
        if (index != null) {
            if (patternLength == 1) {
                return (Map)matchWithCharFunction.apply(Character.valueOf(pattern.charAt(0)), index);
            }
            if (lastMatchedTypes != null) {
                return (Map)matchWithStringFunction.apply(pattern, lastMatchedTypes);
            }
            return (Map)matchWithStringFunction.apply(pattern, index);
        }
        return null;
    }
}

