/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import javax.swing.JFrame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.util.swing.AbstractSwingWorker;

public class SaveAllSourcesController {
    private final API api;
    private final JFrame mainFrame;

    public SaveAllSourcesController(API api, JFrame mainFrame) {
        this.api = api;
        this.mainFrame = mainFrame;
    }

    public void show(SourcesSavable savable, File file) {
        SaveAllSourcesWorker saveAllSourcesWorker = new SaveAllSourcesWorker(savable, file);
        saveAllSourcesWorker.execute();
    }

    private final class SaveAllSourcesWorker
    extends AbstractSwingWorker<Void, Void> {
        private final SourcesSavable savable;
        private final File file;

        private SaveAllSourcesWorker(SourcesSavable savable, File file) {
            super(SaveAllSourcesController.this.mainFrame, "Saving...");
            this.savable = savable;
            this.file = file;
        }

        @Override
        protected Void doInBackground() throws Exception {
            block3: {
                try {
                    Path path = Paths.get(this.file.toURI());
                    Files.deleteIfExists(path);
                    this.trySave(path);
                    if (this.isCancelled()) {
                        Files.deleteIfExists(path);
                    }
                }
                catch (Exception t) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)t)) break block3;
                    throw new AssertionError();
                }
            }
            return null;
        }

        @Override
        protected void done() {
            block4: {
                super.done();
                try {
                    this.get();
                }
                catch (InterruptedException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block4;
                    throw new AssertionError();
                }
            }
        }

        private void trySave(Path path) {
            block2: {
                try {
                    this.savable.save(SaveAllSourcesController.this.api, path, this::getProgressPercentage, this::setProgressPercentage, this::isCancelled);
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block2;
                    throw new AssertionError();
                }
            }
        }
    }
}

