/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.awt.Point;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.controller.SelectLocationController;
import org.jd.gui.util.net.UriUtil;
import org.jd.gui.view.OpenTypeHierarchyView;

public class OpenTypeHierarchyController
implements IndexesChangeListener {
    private final API api;
    private final ScheduledExecutorService executor;
    private final OpenTypeHierarchyView openTypeHierarchyView;
    private final SelectLocationController selectLocationController;
    private Collection<Future<Indexes>> collectionOfFutureIndexes;
    private Consumer<URI> openCallback;

    public OpenTypeHierarchyController(API api, ScheduledExecutorService executor, JFrame mainFrame) {
        this.api = api;
        this.executor = executor;
        this.openTypeHierarchyView = new OpenTypeHierarchyView(api, mainFrame, this::onTypeSelected);
        this.selectLocationController = new SelectLocationController(api, mainFrame);
    }

    public void show(Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, String typeName, Consumer<URI> openCallback) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        this.openCallback = openCallback;
        this.executor.execute(() -> {
            this.openTypeHierarchyView.showWaitCursor();
            SwingUtilities.invokeLater(() -> {
                this.openTypeHierarchyView.hideWaitCursor();
                this.openTypeHierarchyView.show(collectionOfFutureIndexes, entry, typeName);
            });
        });
    }

    protected void onTypeSelected(Point leftBottom, Collection<Container.Entry> entries, String typeName) {
        if (entries.size() == 1) {
            this.openCallback.accept(UriUtil.createURI(this.api, this.collectionOfFutureIndexes, entries.iterator().next(), null, typeName));
        } else {
            this.selectLocationController.show(new Point(leftBottom.x + 16 + 2, leftBottom.y + 2), entries, (Container.Entry entry) -> this.openCallback.accept(UriUtil.createURI(this.api, this.collectionOfFutureIndexes, entry, null, typeName)), this.openTypeHierarchyView::focus);
        }
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        if (this.openTypeHierarchyView.isVisible()) {
            this.collectionOfFutureIndexes = collectionOfFutureIndexes;
            this.openTypeHierarchyView.updateTree(collectionOfFutureIndexes);
        }
    }
}

