/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentCopyable;
import org.jd.gui.api.feature.ContentIndexable;
import org.jd.gui.api.feature.ContentSavable;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.ContentSelectable;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.controller.AboutController;
import org.jd.gui.controller.GoToController;
import org.jd.gui.controller.OpenTypeController;
import org.jd.gui.controller.OpenTypeHierarchyController;
import org.jd.gui.controller.PreferencesController;
import org.jd.gui.controller.SaveAllSourcesController;
import org.jd.gui.controller.SearchInConstantPoolsController;
import org.jd.gui.controller.SelectLocationController;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.model.history.History;
import org.jd.gui.service.actions.ContextualActionsFactoryService;
import org.jd.gui.service.container.ContainerFactoryService;
import org.jd.gui.service.fileloader.FileLoaderService;
import org.jd.gui.service.indexer.IndexerService;
import org.jd.gui.service.mainpanel.PanelFactoryService;
import org.jd.gui.service.pastehandler.PasteHandlerService;
import org.jd.gui.service.preferencespanel.PreferencesPanelService;
import org.jd.gui.service.sourceloader.Artifact;
import org.jd.gui.service.sourceloader.MavenOrgSourceLoaderProvider;
import org.jd.gui.service.sourceloader.SourceLoaderService;
import org.jd.gui.service.sourcesaver.SourceSaverService;
import org.jd.gui.service.treenode.TreeNodeFactoryService;
import org.jd.gui.service.type.TypeFactoryService;
import org.jd.gui.service.uriloader.UriLoaderService;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.spi.FileLoader;
import org.jd.gui.spi.Indexer;
import org.jd.gui.spi.PanelFactory;
import org.jd.gui.spi.PasteHandler;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.spi.TypeFactory;
import org.jd.gui.spi.UriLoader;
import org.jd.gui.util.TempFile;
import org.jd.gui.util.ZOutputStream;
import org.jd.gui.util.container.JarContainerEntryUtil;
import org.jd.gui.util.matcher.ArtifactVersionMatcher;
import org.jd.gui.util.net.UriUtil;
import org.jd.gui.util.swing.AbstractSwingWorker;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.MainView;
import org.jd.util.SHA1Util;
import tim.jarcomp.CompareWindow;

public class MainController
implements API {
    private static final String INDEXES = "indexes";
    private final Configuration configuration;
    private MainView mainView;
    private GoToController goToController;
    private OpenTypeController openTypeController;
    private OpenTypeHierarchyController openTypeHierarchyController;
    private PreferencesController preferencesController;
    private SearchInConstantPoolsController searchInConstantPoolsController;
    private SaveAllSourcesController saveAllSourcesController;
    private SelectLocationController selectLocationController;
    private AboutController aboutController;
    private SourceLoaderService sourceLoaderService;
    private final History history = new History();
    private JComponent currentPage;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final List<IndexesChangeListener> containerChangeListeners = new ArrayList<IndexesChangeListener>();

    public MainController(Configuration configuration) {
        this.configuration = configuration;
        SwingUtil.invokeLater(() -> {
            this.mainView = new MainView<JComponent>(configuration, this, this.history, e -> this.onOpen(), e -> this.onCompare(), e -> this.onClose(), e -> this.onSaveSource(), e -> this.onSaveAllSources(), e -> System.exit(0), e -> this.onCopy(), e -> this.onPaste(), e -> this.onSelectAll(), e -> this.onFind(), e -> this.onFindPrevious(), e -> this.onFindNext(), e -> this.onFindCriteriaChanged(), this::onFindCriteriaChanged, e -> this.onOpenType(), e -> this.onOpenTypeHierarchy(), e -> this.onGoTo(), e -> this.openURI(this.history.backward()), e -> this.openURI(this.history.forward()), e -> this.onSearch(), e -> this.onJdWebSite(), e -> this.onJdGuiIssues(), e -> this.onJdCoreIssues(), e -> this.onPreferences(), e -> this.onAbout(), this::panelClosed, x$0 -> this.onCurrentPageChanged((JComponent)x$0), this::openFile);
        });
    }

    public void show(List<File> files) {
        SwingUtil.invokeLater(() -> {
            this.mainView.show(this.configuration.getMainWindowLocation(), this.configuration.getMainWindowSize(), this.configuration.isMainWindowMaximize());
            if (!files.isEmpty()) {
                this.openFiles(files);
            }
        });
        this.executor.schedule(() -> {
            UriLoaderService.getInstance();
            FileLoaderService.getInstance();
            ContainerFactoryService.getInstance();
            IndexerService.getInstance();
            TreeNodeFactoryService.getInstance();
            TypeFactoryService.getInstance();
            SwingUtil.invokeLater(() -> {
                this.mainView.updateRecentFilesMenu(this.configuration.getRecentFiles());
                JFrame mainFrame = this.mainView.getMainFrame();
                this.saveAllSourcesController = new SaveAllSourcesController(this, mainFrame);
                this.openTypeController = new OpenTypeController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.openTypeController);
                this.openTypeHierarchyController = new OpenTypeHierarchyController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.openTypeHierarchyController);
                this.goToController = new GoToController(this.configuration, mainFrame);
                this.searchInConstantPoolsController = new SearchInConstantPoolsController(this, this.executor, mainFrame);
                this.containerChangeListeners.add(this.searchInConstantPoolsController);
                this.preferencesController = new PreferencesController(this.configuration, mainFrame, PreferencesPanelService.getInstance().getProviders());
                this.selectLocationController = new SelectLocationController(this, mainFrame);
                this.aboutController = new AboutController(mainFrame);
                this.sourceLoaderService = new SourceLoaderService();
                mainFrame.addComponentListener(new MainFrameListener(this.configuration));
                mainFrame.setTransferHandler(new FilesTransferHandler());
                new JFileChooser().addChoosableFileFilter(new FileNameExtensionFilter("", "dummy"));
                FileSystemView.getFileSystemView().isFileSystemRoot(new File("dummy"));
                JLayer layer = new JLayer();
            });
        }, 400L, TimeUnit.MILLISECONDS);
        PasteHandlerService.getInstance();
        PreferencesPanelService.getInstance();
        ContextualActionsFactoryService.getInstance();
        SourceSaverService.getInstance();
    }

    protected void onOpen() {
        Map<String, FileLoader> loaders = FileLoaderService.getInstance().getMapProviders();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> extensions = new ArrayList<String>(loaders.keySet());
        Collections.sort(extensions);
        for (String extension : extensions) {
            sb.append("*.").append(extension).append(", ");
        }
        sb.setLength(sb.length() - 2);
        String description = sb.toString();
        String[] array = extensions.toArray(new String[0]);
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getFileFilter());
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("All files (" + description + ")", array));
        for (String extension : extensions) {
            FileLoader loader = loaders.get(extension);
            chooser.addChoosableFileFilter(new FileNameExtensionFilter(loader.getDescription(), loader.getExtensions()));
        }
        chooser.setCurrentDirectory(this.configuration.getRecentLoadDirectory());
        if (chooser.showOpenDialog(this.mainView.getMainFrame()) == 0) {
            this.configuration.setRecentLoadDirectory(chooser.getCurrentDirectory());
            this.openFile(chooser.getSelectedFile());
        }
    }

    protected void onCompare() {
        CompareWindow window = new CompareWindow(this);
        window.startCompare();
    }

    protected void onClose() {
        this.mainView.closeCurrentTab();
    }

    protected void onSaveSource() {
        if (this.currentPage instanceof ContentSavable) {
            ContentSavable cs = (ContentSavable)((Object)this.currentPage);
            JFileChooser chooser = new JFileChooser();
            JFrame mainFrame = this.mainView.getMainFrame();
            chooser.setSelectedFile(new File(this.configuration.getRecentSaveDirectory(), cs.getFileName()));
            if (chooser.showSaveDialog(mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.configuration.setRecentSaveDirectory(chooser.getCurrentDirectory());
                if (selectedFile.exists()) {
                    String title = "Are you sure?";
                    String message = "The file '" + selectedFile.getAbsolutePath() + "' already exists.\n Do you want to replace the existing file?";
                    if (JOptionPane.showConfirmDialog(mainFrame, message, title, 0) == 0) {
                        this.save(selectedFile);
                    }
                } else {
                    this.save(selectedFile);
                }
            }
        }
    }

    protected void save(File selectedFile) {
        block9: {
            try (FileOutputStream os = new FileOutputStream(selectedFile);){
                ((ContentSavable)((Object)this.currentPage)).save(this, os);
            }
            catch (FileNotFoundException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                JOptionPane.showMessageDialog(this.currentPage, "Not authorized to save to this destination. Please restart as administrator or choose another location.", "Access denied", 0);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
    }

    protected void onSaveAllSources() {
        Object currentPanel = this.mainView.getSelectedMainPanel();
        if (currentPanel instanceof SourcesSavable) {
            SourcesSavable sourcesSavable = (SourcesSavable)currentPanel;
            JFileChooser chooser = new JFileChooser();
            JFrame mainFrame = this.mainView.getMainFrame();
            chooser.setSelectedFile(new File(sourcesSavable.getSourceFileName()));
            if (chooser.showSaveDialog(mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                this.configuration.setRecentSaveDirectory(chooser.getCurrentDirectory());
                if (selectedFile.exists()) {
                    String title = "Are you sure?";
                    String message = "The file '" + selectedFile.getAbsolutePath() + "' already exists.\n Do you want to replace the existing file?";
                    if (JOptionPane.showConfirmDialog(mainFrame, message, title, 0) == 0) {
                        this.saveAllSourcesController.show(sourcesSavable, selectedFile);
                    }
                } else {
                    this.saveAllSourcesController.show(sourcesSavable, selectedFile);
                }
            }
        }
    }

    protected void onCopy() {
        if (this.currentPage instanceof ContentCopyable) {
            ContentCopyable cc = (ContentCopyable)((Object)this.currentPage);
            cc.copy();
        }
    }

    protected void onPaste() {
        block4: {
            try {
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Object obj = transferable.getTransferData(DataFlavor.stringFlavor);
                    PasteHandler pasteHandler = PasteHandlerService.getInstance().get(obj);
                    if (pasteHandler != null) {
                        pasteHandler.paste(this, obj);
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block4;
                throw new AssertionError();
            }
        }
    }

    protected void onSelectAll() {
        if (this.currentPage instanceof ContentSelectable) {
            ContentSelectable cs = (ContentSelectable)((Object)this.currentPage);
            cs.selectAll();
        }
    }

    protected void onFind() {
        if (this.currentPage instanceof ContentSearchable) {
            this.mainView.showFindPanel();
        }
    }

    protected void onFindCriteriaChanged() {
        if (this.currentPage instanceof ContentSearchable) {
            ContentSearchable cs = (ContentSearchable)((Object)this.currentPage);
            this.mainView.setFindBackgroundColor(cs.highlightText(this.mainView.getFindText(), this.mainView.getFindCaseSensitive()));
        }
    }

    protected void onFindNext() {
        if (this.currentPage instanceof ContentSearchable) {
            ContentSearchable cs = (ContentSearchable)((Object)this.currentPage);
            cs.findNext(this.mainView.getFindText(), this.mainView.getFindCaseSensitive());
        }
    }

    protected void onOpenType() {
        this.openTypeController.show(this.getCollectionOfFutureIndexes(), this::openURI);
    }

    protected void onOpenTypeHierarchy() {
        if (this.currentPage instanceof FocusedTypeGettable) {
            FocusedTypeGettable ftg = (FocusedTypeGettable)((Object)this.currentPage);
            this.openTypeHierarchyController.show(this.getCollectionOfFutureIndexes(), ftg.getEntry(), ftg.getFocusedTypeName(), this::openURI);
        }
    }

    protected void onGoTo() {
        if (this.currentPage instanceof LineNumberNavigable) {
            LineNumberNavigable lnn = (LineNumberNavigable)((Object)this.currentPage);
            this.goToController.show(lnn, lnn::goToLineNumber);
        }
    }

    protected void onSearch() {
        this.searchInConstantPoolsController.show(this.getCollectionOfFutureIndexes(), this::openURI);
    }

    protected void onFindPrevious() {
        if (this.currentPage instanceof ContentSearchable) {
            ContentSearchable cs = (ContentSearchable)((Object)this.currentPage);
            cs.findPrevious(this.mainView.getFindText(), this.mainView.getFindCaseSensitive());
        }
    }

    protected void onJdWebSite() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("http://java-decompiler.github.io"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onJdGuiIssues() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("https://github.com/java-decompiler/jd-gui/issues"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onJdCoreIssues() {
        block3: {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create("https://github.com/java-decompiler/jd-core/issues"));
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    protected void onPreferences() {
        this.preferencesController.show(() -> {
            this.checkPreferencesChange(this.currentPage);
            this.mainView.preferencesChanged(this.getPreferences());
        });
    }

    protected void onAbout() {
        this.aboutController.show();
    }

    protected void onCurrentPageChanged(JComponent page) {
        this.currentPage = page;
        this.checkPreferencesChange(page);
        this.checkIndexesChange(page);
    }

    protected void checkPreferencesChange(JComponent page) {
        if (page instanceof PreferencesChangeListener) {
            Integer lastHashcode;
            PreferencesChangeListener pcl = (PreferencesChangeListener)((Object)page);
            Map<String, String> preferences = this.configuration.getPreferences();
            Integer currentHashcode = preferences.hashCode();
            if (!currentHashcode.equals(lastHashcode = (Integer)page.getClientProperty("preferences-hashCode"))) {
                pcl.preferencesChanged(preferences);
                page.putClientProperty("preferences-hashCode", currentHashcode);
            }
        }
    }

    protected void checkIndexesChange(JComponent page) {
        if (page instanceof IndexesChangeListener) {
            Integer lastHashcode;
            IndexesChangeListener icl = (IndexesChangeListener)((Object)page);
            Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
            Integer currentHashcode = collectionOfFutureIndexes.hashCode();
            if (!currentHashcode.equals(lastHashcode = (Integer)page.getClientProperty("collectionOfFutureIndexes-hashCode"))) {
                icl.indexesChanged(collectionOfFutureIndexes);
                page.putClientProperty("collectionOfFutureIndexes-hashCode", currentHashcode);
            }
        }
    }

    public void openFile(File file) {
        this.openFiles(Collections.singletonList(file));
    }

    public void compareFiles(List<File> files) {
        CompareWindow window = new CompareWindow(this);
        window.startCompare(files.get(0), files.get(1));
    }

    public void showGAVs(Set<File> files, Map<File, String> sha1Map, DoubleSupplier getProgressFunction, DoubleConsumer setProgressFunction, BooleanSupplier isCancelledFunction) {
        block25: {
            TreeSet<Artifact> artifacts = new TreeSet<Artifact>();
            TreeSet<Artifact> missingArtifacts = new TreeSet<Artifact>();
            TreeSet<Artifact> missingArtifactsWithGroup = new TreeSet<Artifact>();
            for (File file : files) {
                try {
                    String sha1 = sha1Map.computeIfAbsent(file, SHA1Util::computeSHA1);
                    Artifact artifact = MavenOrgSourceLoaderProvider.buildArtifactFromURI(file, sha1);
                    if (artifact != null && artifact.found()) {
                        artifacts.add(artifact);
                    } else {
                        missingArtifacts.add(MainController.inferArtifactFromFileName(file));
                        missingArtifactsWithGroup.add(MainController.inferArtifactFromPackageAndManifest(file));
                    }
                    double progress = 100.0 / (double)files.size();
                    double cumulativeProgress = getProgressFunction.getAsDouble() + progress;
                    if (cumulativeProgress <= 100.0) {
                        setProgressFunction.accept(cumulativeProgress);
                    }
                    if (!isCancelledFunction.getAsBoolean()) continue;
                    return;
                }
                catch (Exception e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                }
            }
            try (TempFile tempFile = new TempFile(".zip");){
                try (FileOutputStream out = new FileOutputStream(tempFile);
                     ZOutputStream zos = new ZOutputStream(out);){
                    MainController.writeGradleBuildEntry(zos, files, artifacts, missingArtifacts);
                    MainController.writeMavenBuildEntry(zos, artifacts, missingArtifactsWithGroup);
                    MainController.writeBatchFile(missingArtifactsWithGroup, zos);
                }
                this.openFiles(Collections.singletonList(tempFile));
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block25;
                throw new AssertionError();
            }
        }
    }

    private static void writeBatchFile(Set<Artifact> missingArtifactsWithGroup, ZOutputStream zos) throws IOException {
        zos.writeln("@echo off");
        for (Artifact artifact : missingArtifactsWithGroup) {
            if (!MainController.acceptArtifact(artifact)) continue;
            zos.write("call mvn deploy:deploy-file -DrepositoryId=%REPO_ID% -Durl=%REPO_URL%");
            zos.write(" -DgroupId=");
            zos.write(artifact.groupId());
            zos.write(" -Dfile=");
            zos.write(artifact.fileName());
            zos.write(" -DartifactId=");
            zos.write(artifact.artifactId());
            zos.write(" -Dversion=");
            zos.writeln(artifact.version());
        }
        zos.closeEntry();
    }

    private static boolean acceptArtifact(Artifact a) {
        return !a.fileName().contains("sources") && !a.fileName().contains("SNAPSHOT");
    }

    private static void writeMavenBuildEntry(ZOutputStream zos, Set<Artifact> artifacts, Set<Artifact> missingArtifactsWithGroup) throws IOException {
        zos.putNextEntry(new ZipEntry("pom.xml"));
        zos.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<modelVersion>4.0.0</modelVersion>\n<dependencies>\n");
        zos.writeln("    <!-- Thirdparty libraries available on maven central -->");
        for (Artifact artifact : artifacts) {
            MainController.writeMavenDependency(zos, artifact);
        }
        zos.writeln("    <!-- Vendor libraries and other libraries without sources -->");
        for (Artifact artifact : missingArtifactsWithGroup) {
            if (!MainController.acceptArtifact(artifact)) continue;
            MainController.writeMavenDependency(zos, artifact);
        }
        zos.write("</dependencies>\n</project>\n");
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("mvn_deploy.bat"));
    }

    private static void writeGradleBuildEntry(ZOutputStream zos, Set<File> files, Set<Artifact> artifacts, Set<Artifact> missingArtifacts) throws IOException {
        zos.putNextEntry(new ZipEntry("build.gradle"));
        zos.writeln("plugins {");
        zos.writeln("    id 'java'");
        zos.writeln("}");
        zos.writeln("");
        zos.writeln("repositories {");
        zos.writeln("    mavenCentral()");
        zos.writeln("    flatDir {");
        zos.write("        dirs ");
        Set dirs = files.stream().map(File::getParent).collect(Collectors.toSet());
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            String dir = (String)it.next();
            zos.write("\"");
            if (dir == null) {
                zos.write("lib");
            } else {
                zos.write(dir);
            }
            zos.write("\"");
            if (!it.hasNext()) continue;
            zos.write(", ");
        }
        zos.writeln("");
        zos.writeln("    }");
        zos.writeln("}");
        zos.writeln("");
        zos.writeln("dependencies {");
        if (!artifacts.isEmpty()) {
            zos.writeln("    // Thirdparty libraries available on maven central");
        }
        for (Artifact artifact : artifacts) {
            zos.write("    compile('");
            zos.write(artifact.groupId());
            zos.write(":");
            zos.write(artifact.artifactId());
            zos.write(":");
            zos.write(artifact.version());
            zos.writeln("') { transitive = false }");
        }
        if (!missingArtifacts.isEmpty()) {
            zos.writeln("    // Vendor libraries and other libraries without sources");
        }
        for (Artifact artifact : missingArtifacts) {
            if (!MainController.acceptArtifact(artifact)) continue;
            zos.write("    compile ':");
            zos.write(artifact.artifactId());
            if (!artifact.version().isEmpty()) {
                zos.write(":");
                zos.write(artifact.version());
            }
            zos.writeln("'");
        }
        zos.write("}");
        zos.closeEntry();
    }

    private static void writeMavenDependency(ZOutputStream zos, Artifact artifact) throws IOException {
        zos.writeln("    <dependency>");
        zos.write("      <groupId>");
        zos.write(artifact.groupId());
        zos.writeln("</groupId>");
        zos.write("      <artifactId>");
        zos.write(artifact.artifactId());
        zos.writeln("</artifactId>");
        zos.write("      <version>");
        zos.write(artifact.version());
        zos.writeln("</version>");
        zos.writeln("    </dependency>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Artifact inferArtifactFromPackageAndManifest(File file) {
        String baseFileName = FilenameUtils.getBaseName((String)file.getName());
        ArtifactVersionMatcher artifactVersionMatcher = new ArtifactVersionMatcher();
        artifactVersionMatcher.parse(baseFileName);
        if (!file.exists()) {
            String artifactId = artifactVersionMatcher.getArtifactId();
            String version = artifactVersionMatcher.getVersion();
            return new Artifact("com.mycompany", artifactId, version, file.getName(), false, false);
        }
        try (JarFile jarFile = new JarFile(file);){
            String version;
            Manifest manifest222 = jarFile.getManifest();
            if (manifest222 == null) {
                String artifactId = artifactVersionMatcher.getArtifactId();
                String version2 = artifactVersionMatcher.getVersion();
                Artifact artifact = new Artifact(artifactId, artifactId, version2, file.getName(), false, false);
                return artifact;
            }
            Attributes mainAttributes = manifest222.getMainAttributes();
            String groupId = mainAttributes.getValue("Implementation-Vendor-Id");
            if (groupId == null) {
                groupId = mainAttributes.getValue("Bundle-SymbolicName");
            }
            if (groupId == null) {
                groupId = JarContainerEntryUtil.inferGroupFromFile(jarFile);
            }
            if ((version = mainAttributes.getValue("Implementation-Version")) == null) {
                version = mainAttributes.getValue("Bundle-Version");
            }
            if (version == null) {
                version = artifactVersionMatcher.getVersion();
            }
            String artifactId = artifactVersionMatcher.getArtifactId();
            Artifact artifact = new Artifact(groupId, artifactId, version, file.getName(), false, false);
            return artifact;
        }
        catch (IOException e) {
            if ($assertionsDisabled) return null;
            if (ExceptionUtil.printStackTrace((Throwable)e)) return null;
            throw new AssertionError();
        }
    }

    private static Artifact inferArtifactFromFileName(File file) {
        String baseFileName = FilenameUtils.getBaseName((String)file.getName());
        ArtifactVersionMatcher artifactVersionMatcher = new ArtifactVersionMatcher();
        artifactVersionMatcher.parse(baseFileName);
        String artifactId = artifactVersionMatcher.getArtifactId();
        String version = artifactVersionMatcher.getVersion();
        return new Artifact(artifactId, artifactId, version, file.getName(), false, false);
    }

    public void openFiles(List<File> files) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (File file : files) {
            if (file.exists()) {
                FileLoader loader = this.getFileLoader(file);
                if (loader == null || loader.accept(this, file)) continue;
                errors.add((CallSite)((Object)("Invalid input fileloader: '" + file.getAbsolutePath() + "'")));
                continue;
            }
            errors.add((CallSite)((Object)("File not found: '" + file.getAbsolutePath() + "'")));
        }
        if (errors.isEmpty()) {
            for (File file : files) {
                if (!this.openURI(file.toURI())) continue;
                this.configuration.addRecentFile(file);
                this.mainView.updateRecentFilesMenu(this.configuration.getRecentFiles());
            }
        } else {
            StringBuilder messages = new StringBuilder();
            int index = 0;
            for (String string : errors) {
                if (index > 0) {
                    messages.append('\n');
                }
                if (index >= 20) {
                    messages.append("...");
                    break;
                }
                messages.append(string);
                ++index;
            }
            JOptionPane.showMessageDialog(this.mainView.getMainFrame(), messages.toString(), "Error", 0);
        }
    }

    protected void panelClosed() {
        SwingUtil.invokeLater(() -> {
            Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
            for (IndexesChangeListener listener : this.containerChangeListeners) {
                listener.indexesChanged(collectionOfFutureIndexes);
            }
            if (this.currentPage instanceof IndexesChangeListener) {
                IndexesChangeListener icl = (IndexesChangeListener)((Object)this.currentPage);
                icl.indexesChanged(collectionOfFutureIndexes);
            }
        });
    }

    @Override
    public boolean openURI(URI uri) {
        if (uri != null) {
            UriLoader uriLoader;
            boolean success = this.mainView.openUri(uri);
            if (!success && (uriLoader = this.getUriLoader(uri)) != null) {
                success = uriLoader.load(this, uri);
            }
            if (success) {
                this.addURI(uri);
            }
            return success;
        }
        return false;
    }

    @Override
    public boolean openURI(int x, int y, Collection<Container.Entry> entries, String query, String fragment) {
        if (entries != null) {
            if (entries.size() == 1) {
                Container.Entry entry2 = entries.iterator().next();
                return this.openURI(UriUtil.createURI(this, this.getCollectionOfFutureIndexes(), entry2, query, fragment));
            }
            Collection<Future<Indexes>> collectionOfFutureIndexes = this.getCollectionOfFutureIndexes();
            this.selectLocationController.show(new Point(x + 16 + 2, y + 2), entries, entry -> this.openURI(UriUtil.createURI(this, collectionOfFutureIndexes, entry, query, fragment)), () -> {});
            return true;
        }
        return false;
    }

    @Override
    public void addURI(URI uri) {
        this.history.add(uri);
        SwingUtil.invokeLater(() -> this.mainView.updateHistoryActions());
    }

    @Override
    public <T extends JComponent> void addPanel(File file, String title, Supplier<Icon> iconSupplier, String tip, T component) {
        this.mainView.addMainPanel(title, iconSupplier, tip, component);
        if (component instanceof ContentIndexable && file != null) {
            ContentIndexable ci = (ContentIndexable)((Object)component);
            UIManager.put("ProgressMonitor.progressText", title);
            IndexerWorker worker = new IndexerWorker(component, ci);
            worker.execute();
            component.putClientProperty(INDEXES, worker);
        }
    }

    @Override
    public Collection<Action> getContextualActions(Container.Entry entry, String fragment) {
        return ContextualActionsFactoryService.getInstance().get(this, entry, fragment);
    }

    @Override
    public FileLoader getFileLoader(File file) {
        return FileLoaderService.getInstance().get(file);
    }

    @Override
    public UriLoader getUriLoader(URI uri) {
        return UriLoaderService.getInstance().get(this, uri);
    }

    @Override
    public PanelFactory getMainPanelFactory(Container container) {
        return PanelFactoryService.getInstance().get(container);
    }

    @Override
    public ContainerFactory getContainerFactory(Path rootPath) {
        return ContainerFactoryService.getInstance().get(this, rootPath);
    }

    @Override
    public TreeNodeFactory getTreeNodeFactory(Container.Entry entry) {
        return TreeNodeFactoryService.getInstance().get(entry);
    }

    @Override
    public TypeFactory getTypeFactory(Container.Entry entry) {
        return TypeFactoryService.getInstance().get(entry);
    }

    @Override
    public Indexer getIndexer(Container.Entry entry) {
        return IndexerService.getInstance().get(entry);
    }

    @Override
    public SourceSaver getSourceSaver(Container.Entry entry) {
        return SourceSaverService.getInstance().get(entry);
    }

    @Override
    public Map<String, String> getPreferences() {
        return this.configuration.getPreferences();
    }

    @Override
    public Collection<Future<Indexes>> getCollectionOfFutureIndexes() {
        List mainPanels = this.mainView.getMainPanels();
        ArrayList<Future<Indexes>> list = new ArrayList<Future<Indexes>>(mainPanels.size()){
            private static final long serialVersionUID = 1L;

            @Override
            public int hashCode() {
                int hashCode;
                block5: {
                    hashCode = 1;
                    try {
                        for (Future futureIndexes : this) {
                            hashCode *= 31;
                            if (!futureIndexes.isDone()) continue;
                            hashCode += ((Indexes)futureIndexes.get()).hashCode();
                        }
                    }
                    catch (InterruptedException e) {
                        assert (ExceptionUtil.printStackTrace((Throwable)e));
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block5;
                        throw new AssertionError();
                    }
                }
                return hashCode;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || o.getClass() != this.getClass()) {
                    return false;
                }
                return super.equals(o);
            }
        };
        for (JComponent panel : mainPanels) {
            Future futureIndexes = (Future)panel.getClientProperty(INDEXES);
            if (futureIndexes == null) continue;
            list.add(futureIndexes);
        }
        return list;
    }

    @Override
    public Collection<Indexes> getCollectionOfIndexes() {
        List mainPanels = this.mainView.getMainPanels();
        ArrayList<Indexes> list = new ArrayList<Indexes>(mainPanels.size());
        for (JComponent panel : mainPanels) {
            Future indexes = (Future)panel.getClientProperty(INDEXES);
            if (indexes == null) continue;
            try {
                list.add((Indexes)indexes.get());
            }
            catch (InterruptedException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
            }
        }
        return list;
    }

    @Override
    public String getSource(Container.Entry entry) {
        return this.sourceLoaderService.getSource(this, entry);
    }

    @Override
    public void loadSource(Container.Entry entry, API.LoadSourceListener listener) {
        this.executor.execute(() -> {
            String source = this.sourceLoaderService.loadSource(this, entry);
            if (source != null && !source.isEmpty()) {
                listener.sourceLoaded(source);
            }
        });
    }

    @Override
    public File loadSourceFile(Container.Entry entry) {
        return this.sourceLoaderService.getSourceFile(this, entry);
    }

    @Override
    public void repaint() {
        this.mainView.repaint();
    }

    private final class IndexerWorker
    extends AbstractSwingWorker<Indexes, Void> {
        private final ContentIndexable ci;

        private IndexerWorker(Component component, ContentIndexable ci) {
            super(component, "Indexing ...");
            this.ci = ci;
        }

        @Override
        protected Indexes doInBackground() throws Exception {
            return this.ci.index(MainController.this, this::getProgressPercentage, this::setProgressPercentage, this::isCancelled);
        }

        @Override
        protected void done() {
            super.done();
            Collection<Future<Indexes>> collectionOfFutureIndexes = MainController.this.getCollectionOfFutureIndexes();
            for (IndexesChangeListener listener : MainController.this.containerChangeListeners) {
                listener.indexesChanged(collectionOfFutureIndexes);
            }
            if (MainController.this.currentPage instanceof IndexesChangeListener) {
                IndexesChangeListener icl = (IndexesChangeListener)((Object)MainController.this.currentPage);
                icl.indexesChanged(collectionOfFutureIndexes);
            }
        }
    }

    protected class MainFrameListener
    extends ComponentAdapter {
        private final Configuration configuration;

        public MainFrameListener(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            JFrame mainFrame = MainController.this.mainView.getMainFrame();
            if ((mainFrame.getExtendedState() & 6) == 6) {
                this.configuration.setMainWindowMaximize(true);
            } else {
                this.configuration.setMainWindowLocation(mainFrame.getLocation());
                this.configuration.setMainWindowMaximize(false);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JFrame mainFrame = MainController.this.mainView.getMainFrame();
            if ((mainFrame.getExtendedState() & 6) == 6) {
                this.configuration.setMainWindowMaximize(true);
            } else {
                this.configuration.setMainWindowSize(mainFrame.getSize());
                this.configuration.setMainWindowMaximize(false);
            }
        }
    }

    protected class FilesTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        protected FilesTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            block8: {
                if (info.isDrop() && info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        List files = (List)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        switch (files.size()) {
                            case 1: {
                                File file = (File)files.get(0);
                                if ("sha1.txt".equals(file.getName())) {
                                    Map<File, String> sha1Map = SHA1Util.readSHA1File(file);
                                    this.launchGAVWorker(info, sha1Map.keySet(), sha1Map);
                                    break;
                                }
                                MainController.this.openFiles(files);
                                break;
                            }
                            case 2: {
                                MainController.this.compareFiles(files);
                                break;
                            }
                            default: {
                                this.launchGAVWorker(info, new HashSet<File>(files), new HashMap<File, String>());
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }

        private void launchGAVWorker(TransferHandler.TransferSupport info, Set<File> files, Map<File, String> sha1Map) {
            GAVWorker worker = new GAVWorker(info.getComponent(), files, sha1Map);
            worker.execute();
        }
    }

    private final class GAVWorker
    extends AbstractSwingWorker<Void, Void> {
        private final Set<File> files;
        private final Map<File, String> sha1Map;

        private GAVWorker(Component component, Set<File> files, Map<File, String> sha1Map) {
            super(component, "Generating POM ...");
            this.files = files;
            this.sha1Map = sha1Map;
        }

        @Override
        protected Void doInBackground() throws Exception {
            MainController.this.showGAVs(this.files, this.sha1Map, this::getProgressPercentage, this::setProgressPercentage, this::isCancelled);
            return null;
        }
    }
}

