/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.controller.MainController;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.service.configuration.ConfigurationPersister;
import org.jd.gui.service.configuration.ConfigurationPersisterService;
import org.jd.gui.util.net.InterProcessCommunicationUtil;

public class App {
    protected static final String SINGLE_INSTANCE = "UIMainWindowPreferencesProvider.singleInstance";
    protected static MainController controller;

    public static void main(String[] args) {
        if (App.checkHelpFlag(args)) {
            JOptionPane.showMessageDialog(null, "Usage: jd-gui [option] [input-file] ...\n\nOption:\n -h Show this help message and exit", "JD-GUI", 1);
        } else {
            Configuration configuration;
            block11: {
                ConfigurationPersister persister = ConfigurationPersisterService.getInstance().get();
                configuration = persister.load();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> persister.save(configuration)));
                if ("true".equals(configuration.getPreferences().get(SINGLE_INSTANCE))) {
                    try {
                        InterProcessCommunicationUtil.listen(receivedArgs -> controller.openFiles(App.newList(receivedArgs)));
                    }
                    catch (Exception notTheFirstInstanceException) {
                        assert (ExceptionUtil.printStackTrace((Throwable)notTheFirstInstanceException));
                        InterProcessCommunicationUtil.send(args);
                        System.exit(0);
                    }
                }
                try {
                    UIManager.setLookAndFeel(configuration.getLookAndFeel());
                }
                catch (Exception e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    configuration.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    try {
                        UIManager.setLookAndFeel(configuration.getLookAndFeel());
                    }
                    catch (Exception ee) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)ee)) break block11;
                        throw new AssertionError();
                    }
                }
            }
            controller = new MainController(configuration);
            controller.show(App.newList(args));
        }
    }

    protected static boolean checkHelpFlag(String[] args) {
        if (args != null) {
            for (String arg : args) {
                if (!"-h".equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    protected static List<File> newList(String[] paths) {
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList<File> files = new ArrayList<File>(paths.length);
        for (String path : paths) {
            if (path.contains("..")) {
                System.err.println(".. in path is disabled");
                continue;
            }
            files.add(new File(path));
        }
        return files;
    }
}

