/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.common;

import io.github.skylot.raung.common.JavaOpCodeFormat;
import java.util.HashMap;
import java.util.Map;

public class JavaOpCodes {
    private static final int OPCODES_COUNT = 202;
    private static final String[] OPCODES = new String[202];
    private static final Map<String, Integer> NAMES_MAP = new HashMap<String, Integer>(202);
    private static final JavaOpCodeFormat[] OPCODES_FORMAT = new JavaOpCodeFormat[202];

    private static void add(int opcode, String name, JavaOpCodeFormat format) {
        JavaOpCodes.OPCODES[opcode] = name;
        NAMES_MAP.put(name, opcode);
        JavaOpCodes.OPCODES_FORMAT[opcode] = format;
    }

    private static void alias(String name, int opcode) {
        NAMES_MAP.put(name, opcode);
    }

    public static String getName(int opcode) {
        return OPCODES[opcode];
    }

    public static int getOpcode(String name) {
        Integer opcode = NAMES_MAP.get(name);
        if (opcode == null) {
            return -1;
        }
        return opcode;
    }

    public static JavaOpCodeFormat getFormat(int opcode) {
        return OPCODES_FORMAT[opcode];
    }

    static {
        JavaOpCodes.add(0, "nop", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(1, "aconst_null", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(2, "iconst_m1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(3, "iconst_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(4, "iconst_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(5, "iconst_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(6, "iconst_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(7, "iconst_4", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(8, "iconst_5", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(9, "lconst_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(10, "lconst_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(11, "fconst_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(12, "fconst_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(13, "fconst_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(14, "dconst_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(15, "dconst_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(16, "bipush", JavaOpCodeFormat.INT);
        JavaOpCodes.add(17, "sipush", JavaOpCodeFormat.INT);
        JavaOpCodes.add(18, "ldc", JavaOpCodeFormat.LDC);
        JavaOpCodes.add(19, "ldc_w", JavaOpCodeFormat.LDC);
        JavaOpCodes.add(20, "ldc2_w", JavaOpCodeFormat.LDC);
        JavaOpCodes.add(21, "iload", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(22, "lload", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(23, "fload", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(24, "dload", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(25, "aload", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(26, "iload_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(27, "iload_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(28, "iload_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(29, "iload_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(30, "lload_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(31, "lload_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(32, "lload_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(33, "lload_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(34, "fload_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(35, "fload_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(36, "fload_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(37, "fload_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(38, "dload_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(39, "dload_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(40, "dload_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(41, "dload_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(42, "aload_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(43, "aload_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(44, "aload_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(45, "aload_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(46, "iaload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(47, "laload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(48, "faload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(49, "daload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(50, "aaload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(51, "baload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(52, "caload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(53, "saload", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(54, "istore", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(55, "lstore", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(56, "fstore", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(57, "dstore", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(58, "astore", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(59, "istore_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(60, "istore_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(61, "istore_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(62, "istore_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(63, "lstore_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(64, "lstore_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(65, "lstore_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(66, "lstore_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(67, "fstore_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(68, "fstore_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(69, "fstore_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(70, "fstore_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(71, "dstore_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(72, "dstore_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(73, "dstore_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(74, "dstore_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(75, "astore_0", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(76, "astore_1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(77, "astore_2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(78, "astore_3", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(79, "iastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(80, "lastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(81, "fastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(82, "dastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(83, "aastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(84, "bastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(85, "castore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(86, "sastore", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(87, "pop", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(88, "pop2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(89, "dup", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(90, "dup_x1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(91, "dup_x2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(92, "dup2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(93, "dup2_x1", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(94, "dup2_x2", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(95, "swap", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(96, "iadd", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(97, "ladd", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(98, "fadd", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(99, "dadd", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(100, "isub", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(101, "lsub", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(102, "fsub", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(103, "dsub", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(104, "imul", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(105, "lmul", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(106, "fmul", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(107, "dmul", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(108, "idiv", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(109, "ldiv", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(110, "fdiv", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(111, "ddiv", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(112, "irem", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(113, "lrem", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(114, "frem", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(115, "drem", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(116, "ineg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(117, "lneg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(118, "fneg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(119, "dneg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(120, "ishl", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(121, "lshl", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(122, "ishr", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(123, "lshr", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(124, "iushr", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(125, "lushr", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(126, "iand", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(127, "land", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(128, "ior", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(129, "lor", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(130, "ixor", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(131, "lxor", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(132, "iinc", JavaOpCodeFormat.IINC);
        JavaOpCodes.add(133, "i2l", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(134, "i2f", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(135, "i2d", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(136, "l2i", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(137, "l2f", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(138, "l2d", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(139, "f2i", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(140, "f2l", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(141, "f2d", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(142, "d2i", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(143, "d2l", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(144, "d2f", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(145, "i2b", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(146, "i2c", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(147, "i2s", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(148, "lcmp", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(149, "fcmpl", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(150, "fcmpg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(151, "dcmpl", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(152, "dcmpg", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(153, "ifeq", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(154, "ifne", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(155, "iflt", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(156, "ifge", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(157, "ifgt", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(158, "ifle", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(159, "if_icmpeq", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(160, "if_icmpne", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(161, "if_icmplt", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(162, "if_icmpge", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(163, "if_icmpgt", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(164, "if_icmple", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(165, "if_acmpeq", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(166, "if_acmpne", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(167, "goto", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(168, "jsr", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(169, "ret", JavaOpCodeFormat.VAR);
        JavaOpCodes.add(170, "tableswitch", JavaOpCodeFormat.SWITCH);
        JavaOpCodes.add(171, "lookupswitch", JavaOpCodeFormat.SWITCH);
        JavaOpCodes.add(172, "ireturn", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(173, "lreturn", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(174, "freturn", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(175, "dreturn", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(176, "areturn", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(177, "return", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(178, "getstatic", JavaOpCodeFormat.FIELD);
        JavaOpCodes.add(179, "putstatic", JavaOpCodeFormat.FIELD);
        JavaOpCodes.add(180, "getfield", JavaOpCodeFormat.FIELD);
        JavaOpCodes.add(181, "putfield", JavaOpCodeFormat.FIELD);
        JavaOpCodes.add(182, "invokevirtual", JavaOpCodeFormat.METHOD);
        JavaOpCodes.add(183, "invokespecial", JavaOpCodeFormat.METHOD);
        JavaOpCodes.add(184, "invokestatic", JavaOpCodeFormat.METHOD);
        JavaOpCodes.add(185, "invokeinterface", JavaOpCodeFormat.METHOD);
        JavaOpCodes.add(186, "invokedynamic", JavaOpCodeFormat.INVOKE_DYNAMIC);
        JavaOpCodes.add(187, "new", JavaOpCodeFormat.TYPE);
        JavaOpCodes.add(188, "newarray", JavaOpCodeFormat.NEW_ARRAY);
        JavaOpCodes.add(189, "anewarray", JavaOpCodeFormat.TYPE);
        JavaOpCodes.add(190, "arraylength", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(191, "athrow", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(192, "checkcast", JavaOpCodeFormat.TYPE);
        JavaOpCodes.add(193, "instanceof", JavaOpCodeFormat.TYPE);
        JavaOpCodes.add(194, "monitorenter", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(195, "monitorexit", JavaOpCodeFormat.NO_ARGS);
        JavaOpCodes.add(196, "wide", JavaOpCodeFormat.UNKNOWN);
        JavaOpCodes.add(197, "multianewarray", JavaOpCodeFormat.NEW_MULTI_ARRAY);
        JavaOpCodes.add(198, "ifnull", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(199, "ifnonnull", JavaOpCodeFormat.JUMP);
        JavaOpCodes.add(201, "jsr_w", JavaOpCodeFormat.JUMP);
        JavaOpCodes.alias("switch", 170);
    }
}

