/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util.swing;

import java.beans.PropertyChangeSupport;

public abstract class BeanProperty<T> {
    private PropertyChangeSupport notificator;
    private String propertyName;
    private boolean forceChange;

    public BeanProperty(PropertyChangeSupport notificator, String propertyName, boolean forceSet) {
        this.notificator = notificator;
        this.propertyName = propertyName;
        this.forceChange = forceSet;
    }

    public BeanProperty(PropertyChangeSupport notificator, String propertyName) {
        this(notificator, propertyName, false);
    }

    public abstract T get();

    protected abstract void setValue(T var1);

    protected void postSetAction(T newValue) {
    }

    public final boolean set(T newValue) {
        T oldValue = this.get();
        boolean result = this.forceChange || !this.sameValues(oldValue, newValue);
        if (result) {
            this.setValue(newValue);
            this.notificator.firePropertyChange(this.propertyName, oldValue, newValue);
            this.postSetAction(newValue);
        }
        return result;
    }

    private boolean sameValues(T a, T b) {
        return a == b || a != null && b != null && a.equals(b);
    }
}

