/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.IListFilter;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.FilterTableHeaderRenderer;
import org.oxbow.swingbits.table.filter.IFilterChangeListener;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.JTableFilter;
import org.oxbow.swingbits.table.filter.TableFilterColumnPopup;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

public final class TableRowFilterSupport {
    private boolean searchable = false;
    private IListFilter searchFilter = CheckListFilterType.CONTAINS;
    private IObjectToStringTranslator translator;
    private final ITableFilter<?> filter;
    private boolean actionsVisible = true;
    private int filterIconPlacement = 10;
    private boolean useTableRenderers = false;
    private ListCellRenderer renderer = null;
    private boolean autoclean = false;

    private TableRowFilterSupport(ITableFilter<?> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public static TableRowFilterSupport forTable(JTable table) {
        return new TableRowFilterSupport(new JTableFilter(table));
    }

    public static TableRowFilterSupport forFilter(ITableFilter<?> filter) {
        return new TableRowFilterSupport(filter);
    }

    public TableRowFilterSupport actions(boolean visible) {
        this.actionsVisible = visible;
        return this;
    }

    public TableRowFilterSupport filterIconPlacement(int filterIconPlacement) {
        if (filterIconPlacement != 10 && filterIconPlacement != 11) {
            throw new UnsupportedOperationException("The filter icon placement can only take the values of SwingConstants.LEADING or SwingConstants.TRAILING");
        }
        this.filterIconPlacement = filterIconPlacement;
        return this;
    }

    public TableRowFilterSupport searchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public TableRowFilterSupport autoclean(boolean autoclean) {
        this.autoclean = autoclean;
        return this;
    }

    public TableRowFilterSupport searchFilter(IListFilter searchFilter) {
        this.searchFilter = searchFilter;
        return this;
    }

    public TableRowFilterSupport searchTransalator(IObjectToStringTranslator translator) {
        this.translator = translator;
        return this;
    }

    public TableRowFilterSupport useTableRenderers(boolean value) {
        this.useTableRenderers = value;
        return this;
    }

    public TableRowFilterSupport onFilterChange(IFilterChangeListener listener) {
        this.filter.addChangeListener(listener);
        return this;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public TableRowFilterSupport checkListRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public JTable apply() {
        TableFilterColumnPopup filterPopup = new TableFilterColumnPopup(this.filter);
        filterPopup.setEnabled(true);
        filterPopup.setActionsVisible(this.actionsVisible);
        filterPopup.setSearchable(this.searchable);
        filterPopup.setSearchFilter(this.searchFilter);
        filterPopup.setSearchTranslator(this.translator);
        filterPopup.setUseTableRenderers(this.useTableRenderers);
        filterPopup.setCellRenderer(this.renderer);
        this.setupTableHeader();
        this.filter.setAutoClean(this.autoclean);
        return this.filter.getTable();
    }

    private void setupTableHeader() {
        Object table = this.filter.getTable();
        this.filter.addChangeListener(new IFilterChangeListener((JTable)table){
            final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            public void filterChanged(ITableFilter<?> filter) {
                this.val$table.getTableHeader().repaint();
            }
        });
        this.setupHeaderRenderers(((JTable)table).getModel(), true);
    }

    public void applyColumnFilters(Map<Integer, Set<DistinctColumnItem>> columnFilters) {
        if (columnFilters == null) {
            return;
        }
        for (Integer key : columnFilters.keySet()) {
            Set<DistinctColumnItem> checked = columnFilters.get(key);
            this.filter.apply(key, checked);
        }
    }

    private void setupHeaderRenderers(TableModel newModel, boolean fullSetup) {
        Object table = this.filter.getTable();
        FilterTableHeaderRenderer headerRenderer = new FilterTableHeaderRenderer(this.filter, this.filterIconPlacement);
        this.filter.modelChanged(newModel);
        for (TableColumn c : Collections.list(((JTable)table).getColumnModel().getColumns())) {
            c.setHeaderRenderer(headerRenderer);
        }
        if (!fullSetup) {
            return;
        }
        ((Container)table).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TableRowFilterSupport.this.setupHeaderRenderers((TableModel)e.getNewValue(), false);
            }
        });
    }
}

