/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.oxbow.swingbits.list.ActionCheckListModel;
import org.oxbow.swingbits.list.CheckList;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.DefaultCheckListModel;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.list.IListFilter;
import org.oxbow.swingbits.misc.JSearchTextField;
import org.oxbow.swingbits.popup.PopupWindow;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.TableAwareCheckListRenderer;
import org.oxbow.swingbits.util.CollectionUtils;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

class TableFilterColumnPopup
extends PopupWindow
implements MouseListener {
    private boolean enabled = false;
    private final CheckList<DistinctColumnItem> filterList = new CheckList.Builder().build();
    private final JSearchTextField searchField = new JSearchTextField();
    private final Map<Integer, ColumnAttrs> colAttrs = new HashMap<Integer, ColumnAttrs>();
    private int mColumnIndex = -1;
    private final ITableFilter<?> filter;
    private boolean searchable;
    private IListFilter searchFilter = CheckListFilterType.CONTAINS;
    private IObjectToStringTranslator translator;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;
    ResourceBundle bundle = ResourceBundle.getBundle("task-dialog");

    public TableFilterColumnPopup(ITableFilter<?> filter) {
        super(true);
        this.filter = filter;
        this.filterList.getList().setVisibleRowCount(8);
        this.setupTableHeader();
        ((Container)filter.getTable()).addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableFilterColumnPopup.this.setupTableHeader();
            }
        });
        ((Container)filter.getTable()).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableFilterColumnPopup.this.colAttrs.clear();
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.perform(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.perform(e);
            }

            private void perform(DocumentEvent e) {
                TableFilterColumnPopup.this.filterList.filter(TableFilterColumnPopup.this.searchField.getText(), TableFilterColumnPopup.this.translator, TableFilterColumnPopup.this.searchFilter);
            }
        });
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void setSearchTranslator(IObjectToStringTranslator tranlsator) {
        this.translator = tranlsator;
    }

    public void setSearchFilter(IListFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setActionsVisible(boolean actionsVisible) {
        this.actionsVisible = actionsVisible;
    }

    public void setUseTableRenderers(boolean reuseRenderers) {
        this.useTableRenderers = reuseRenderers;
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.filterList.setCellRenderer(renderer);
    }

    private void setupTableHeader() {
        JTableHeader header = ((JTable)this.filter.getTable()).getTableHeader();
        if (header != null) {
            header.addMouseListener(this);
        }
    }

    @Override
    protected JComponent buildContent() {
        JPanel owner = new JPanel(new BorderLayout(3, 3));
        owner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        owner.setPreferredSize(new Dimension(250, 150));
        Box commands = new Box(2);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
        toolbar.add(new PopupWindow.CommandAction(this.bundle.getString("Clear_ALL_COLUMN_FILTERS"), (Icon)new ImageIcon(this.getClass().getResource("funnel_delete.png"))){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.clearAllFilters();
            }
        });
        commands.add(toolbar);
        commands.add(Box.createHorizontalGlue());
        commands.add(new JButton(new PopupWindow.CommandAction(this.bundle.getString("Apply")){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.applyColumnFilter();
            }
        }));
        commands.add(Box.createHorizontalStrut(5));
        commands.add(new JButton(new PopupWindow.CommandAction(this.bundle.getString("Cancel"))));
        commands.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        commands.setBackground(UIManager.getColor("Panel.background"));
        commands.setOpaque(true);
        if (this.searchable) {
            owner.add((Component)this.searchField, "North");
        }
        owner.add((Component)new JScrollPane(this.filterList.getList()), "Center");
        owner.add((Component)commands, "South");
        return owner;
    }

    private boolean applyColumnFilter() {
        Collection<DistinctColumnItem> checked = this.filterList.getCheckedItems();
        ICheckListModel<DistinctColumnItem> model = this.filterList.getModel();
        model.filter("", this.translator, CheckListFilterType.CONTAINS);
        this.filter.apply(this.mColumnIndex, checked);
        return true;
    }

    private boolean clearAllFilters() {
        this.filter.clear();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    private void showFilterPopup(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        TableColumnModel colModel = ((JTable)this.filter.getTable()).getColumnModel();
        int vColumnIndex = colModel.getColumnIndexAtX(e.getX());
        if (vColumnIndex < 0) {
            return;
        }
        Rectangle headerRect = ((JTable)this.filter.getTable()).getTableHeader().getHeaderRect(vColumnIndex);
        if (vColumnIndex == 0) {
            headerRect.width -= 2;
        } else {
            headerRect.grow(-2, 0);
        }
        if (!headerRect.contains(e.getX(), e.getY())) {
            return;
        }
        this.mColumnIndex = ((JTable)this.filter.getTable()).convertColumnIndexToModel(vColumnIndex);
        this.setPreferredSize(this.getColumnAttrs((int)vColumnIndex).preferredSize);
        Collection<DistinctColumnItem> distinctItems = this.filter.getDistinctColumnItems(this.mColumnIndex);
        DefaultCheckListModel<DistinctColumnItem> model = new DefaultCheckListModel<DistinctColumnItem>(distinctItems);
        this.filterList.setModel(this.actionsVisible ? new ActionCheckListModel<DistinctColumnItem>(model) : model);
        Collection<DistinctColumnItem> checked = this.filter.getFilterState(this.mColumnIndex);
        this.filterList.setCheckedItems(CollectionUtils.isEmpty(checked) ? distinctItems : checked);
        if (this.useTableRenderers) {
            this.filterList.getList().setCellRenderer(new TableAwareCheckListRenderer((JTable)this.filter.getTable(), vColumnIndex));
        }
        this.show(header, headerRect.x, header.getHeight());
    }

    private ColumnAttrs getColumnAttrs(int column) {
        ColumnAttrs attrs = this.colAttrs.get(column);
        if (attrs == null) {
            attrs = new ColumnAttrs();
            this.colAttrs.put(column, attrs);
        }
        return attrs;
    }

    @Override
    protected void beforeShow() {
        if (this.searchable) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableFilterColumnPopup.this.searchField.setText("");
                    TableFilterColumnPopup.this.searchField.requestFocusInWindow();
                }
            });
        }
    }

    @Override
    public void beforeHide() {
        this.getColumnAttrs((int)this.mColumnIndex).preferredSize = this.getPreferredSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static class ColumnAttrs {
        public Dimension preferredSize;

        ColumnAttrs() {
        }
    }
}

