/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.oxbow.swingbits.list.CheckListRenderer;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;

public class TableAwareCheckListRenderer
extends CheckListRenderer {
    private final JTable table;
    private final int column;

    public TableAwareCheckListRenderer(JTable table, int column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof DistinctColumnItem) {
            DistinctColumnItem item = (DistinctColumnItem)value;
            TableCellRenderer renderer = this.table.getCellRenderer(item.getRow(), this.column);
            try {
                Component cmpt = renderer.getTableCellRendererComponent(this.table, item.getValue(), isSelected, this.hasFocus(), item.getRow(), this.column);
                Method method = cmpt.getClass().getMethod("getText", new Class[0]);
                Object s = method.invoke((Object)cmpt, new Object[0]);
                if (s instanceof String) {
                    this.setText((String)s);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }
}

