/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.popup;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.oxbow.swingbits.popup.PopupMenuResizer;

class ResizablePopupMenu
extends JPopupMenu
implements PopupMenuListener {
    private static final long serialVersionUID = 1L;
    private static final int DOT_SIZE = 2;
    private static final int DOT_START = 2;
    private static final int DOT_STEP = 4;
    private final boolean resizable;

    public ResizablePopupMenu(boolean resizable) {
        this.resizable = resizable;
        if (resizable) {
            PopupMenuResizer.decorate(this);
        }
        this.addPopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.resizable) {
            this.drawResizer(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawResizer(Graphics g) {
        int x = this.getWidth() - 2;
        int y = this.getHeight() - 2;
        Graphics g2 = g.create();
        try {
            int dy = 2;
            int j = 2;
            while (j > 0) {
                int dx = 2;
                int i = 0;
                while (i < j) {
                    this.drawDot(g2, x - dx, y - dy);
                    ++i;
                    dx += 4;
                }
                --j;
                dy += 4;
            }
        }
        finally {
            g2.dispose();
        }
    }

    private void drawDot(Graphics g, int x, int y) {
        g.setColor(Color.WHITE);
        g.fillRect(x, y, 2, 2);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(x - 1, y - 1, 2, 2);
    }
}

