/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.oxbow.swingbits.list.CheckListEditor;
import org.oxbow.swingbits.list.CheckListRenderer;
import org.oxbow.swingbits.list.DefaultCheckListModel;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.list.IListFilter;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

public class CheckList<T> {
    private final JList list;
    private static final MouseAdapter checkBoxEditor = new CheckListEditor();

    private CheckList(JList list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
        this.list.getSelectionModel().setSelectionMode(0);
        if (!this.isEditorAttached()) {
            list.addMouseListener(checkBoxEditor);
        }
        this.list.setCellRenderer(new CheckListRenderer());
        this.setupKeyboardActions(list);
    }

    private CheckList(JList list, CheckListRenderer customRenderer) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (customRenderer == null) {
            throw new NullPointerException();
        }
        this.list = list;
        this.list.getSelectionModel().setSelectionMode(0);
        if (!this.isEditorAttached()) {
            list.addMouseListener(checkBoxEditor);
        }
        this.setCellRenderer(customRenderer);
        this.setupKeyboardActions(list);
    }

    private void setupKeyboardActions(final JList list) {
        String actionKey = "toggle-check";
        list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), actionKey);
        list.getActionMap().put(actionKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckList.this.toggleIndex(list.getSelectedIndex());
            }
        });
    }

    private boolean isEditorAttached() {
        for (MouseListener ml : this.list.getMouseListeners()) {
            if (!(ml instanceof CheckListEditor)) continue;
            return true;
        }
        return false;
    }

    public JList getList() {
        return this.list;
    }

    public void setData(Collection<T> data) {
        this.setModel(new DefaultCheckListModel<T>(data));
    }

    public void setModel(ICheckListModel<T> model) {
        this.list.setModel(model);
    }

    public ICheckListModel<T> getModel() {
        return (ICheckListModel)this.list.getModel();
    }

    public Collection<T> getCheckedItems() {
        return this.getModel().getCheckedItems();
    }

    public void setCheckedItems(Collection<T> elements) {
        this.getModel().setCheckedItems(elements);
    }

    public void filter(String pattern, IObjectToStringTranslator translator, IListFilter listFilter) {
        this.getModel().filter(pattern, translator, listFilter);
    }

    public void toggleIndex(int index) {
        if (index >= 0 && index < this.list.getModel().getSize()) {
            ICheckListModel<T> model;
            model.setCheckedIndex(index, !(model = this.getModel()).isCheckedIndex(index));
        }
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    public static class Builder {
        private JList list;

        public Builder(JList list) {
            this.list = list == null ? new JList() : list;
        }

        public Builder() {
            this(null);
        }

        public <T> CheckList<T> build() {
            return new CheckList(this.list);
        }

        public <T> CheckList<T> build(CheckListRenderer customRenderer) {
            return new CheckList(this.list, customRenderer);
        }
    }
}

