/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.dialog.task.design;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.oxbow.swingbits.dialog.task.ICommandLinkPainter;
import org.oxbow.swingbits.dialog.task.IContentDesign;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.design.DefaultCommandLinkPainter;
import org.oxbow.swingbits.dialog.task.design.TaskDialogContent;

public class DefaultContentDesign
implements IContentDesign {
    protected ICommandLinkPainter commandButtonPainter;

    @Override
    public void updateUIDefaults() {
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.moreDetailsIcon", DefaultContentDesign.createResourceIcon("moreDetails.png"));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.fewerDetailsIcon", DefaultContentDesign.createResourceIcon("fewerDetails.png"));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.commandLinkIcon", DefaultContentDesign.createResourceIcon("arrowGreenRight.png"));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.messageBackground", SystemColor.window);
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.instructionForeground", SystemColor.textHighlight.darker());
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.instructionFont", this.deriveFont("Label.font", null, 1.4f));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.textFont", this.deriveFont("Label.font", null, 1.0f));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.moreDetailsText", TaskDialog.makeKey("MoreDetails"));
        DefaultContentDesign.putUIDefaultIfAbsent("TaskDialog.fewerDetailsText", TaskDialog.makeKey("FewerDetails"));
    }

    @Override
    public TaskDialogContent buildContent() {
        TaskDialogContent content = new TaskDialogContent();
        content.setMinimumSize(new Dimension(200, 70));
        content.lbInstruction.setFont(UIManager.getFont("TaskDialog.instructionFont"));
        content.lbInstruction.setForeground(UIManager.getColor("TaskDialog.instructionForeground"));
        content.lbText.setFont(UIManager.getFont("TaskDialog.textFont"));
        content.pComponent.setOpaque(false);
        content.removeAll();
        content.setLayout((LayoutManager)this.createMigLayout("hidemode 3, fill"));
        JPanel pMessage = new JPanel((LayoutManager)this.createMigLayout("ins dialog, gapx 7, hidemode 3", "[][grow]", "[][]10[grow][]"));
        pMessage.setBackground(UIManager.getColor("TaskDialog.messageBackground"));
        pMessage.add((Component)content.lbIcon, "cell 0 0 0 2, aligny top");
        pMessage.add((Component)content.lbInstruction, "cell 1 0, growx, aligny top");
        pMessage.add((Component)content.lbText, "cell 1 1, growx, aligny top");
        pMessage.add((Component)content.pExpandable, "cell 1 2, grow");
        pMessage.add((Component)content.pComponent, "cell 1 3, grow");
        content.setBackground(pMessage.getBackground());
        content.add((Component)pMessage, "dock center");
        content.pFooter.setLayout((LayoutManager)this.createMigLayout("ins dialog"));
        content.pFooter.add((Component)new JSeparator(), "dock north");
        content.pFooter.add((Component)content.lbFooter, "dock center");
        content.add((Component)content.pFooter, "dock south");
        content.pCommandPane.setLayout((LayoutManager)this.createMigLayout("ins dialog, gapy 2, hidemode 3", "[pref!][grow]", "[pref][pref]"));
        content.pCommandPane.add((Component)content.pCommands, "cell 1 0, alignx right");
        content.pCommandPane.add((Component)content.cbDetails, "cell 0 0");
        content.pCommandPane.add((Component)content.cbFooterCheck, "cell 0 1");
        content.pCommandPane.add((Component)new JSeparator(), "dock north");
        content.add((Component)content.pCommandPane, "dock south");
        return content;
    }

    @Override
    public boolean isCommandButtonSizeLocked() {
        return true;
    }

    private static final String fixDebug(String lc) {
        if (!TaskDialog.isDebugMode()) {
            return lc;
        }
        return lc.toLowerCase().indexOf("debug") < 0 ? "debug," + lc : lc;
    }

    protected MigLayout createMigLayout(String layoutConstraints) {
        return new MigLayout(DefaultContentDesign.fixDebug(layoutConstraints));
    }

    protected MigLayout createMigLayout(String layoutConstraints, String colConstraints, String rowConstraints) {
        return new MigLayout(DefaultContentDesign.fixDebug(layoutConstraints), colConstraints, rowConstraints);
    }

    @Override
    public ICommandLinkPainter getCommandLinkPainter() {
        if (this.commandButtonPainter == null) {
            this.commandButtonPainter = new DefaultCommandLinkPainter();
        }
        return this.commandButtonPainter;
    }

    protected static final Object createResourceIcon(final String name) {
        return new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new ImageIcon(TaskDialog.class.getResource(name));
            }
        };
    }

    protected final Object deriveFont(final String name, final Integer style, final float sizeFactor) {
        return new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                float factor;
                Font font = UIManager.getFont(name);
                float f = factor = sizeFactor == 0.0f ? 1.0f : sizeFactor;
                if (style == null && factor == 1.0f) {
                    return font;
                }
                return font.deriveFont(style == null ? font.getStyle() : style.intValue(), font.getSize2D() * factor);
            }
        };
    }

    protected static final void putUIDefaultIfAbsent(String key, Object value) {
        if (!UIManager.getDefaults().containsKey(key)) {
            UIManager.put(key, value);
        }
    }
}

