/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.dialog.task.design;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.oxbow.swingbits.dialog.task.ICommandLinkPainter;

public class DefaultCommandLinkPainter
implements ICommandLinkPainter {
    private Color messageBackground = this.normalize(UIManager.getColor("TaskDialog.messageBackground"));
    private Color instructionForeground = this.normalize(UIManager.getColor("TaskDialog.instructionForeground"));
    private LinkChrome selectedChrome = new LinkChrome(Color.LIGHT_GRAY.brighter(), Color.GRAY.brighter(), Color.LIGHT_GRAY, 5, 5);
    private LinkChrome armedChrome = new LinkChrome(this.messageBackground, this.instructionForeground, this.instructionForeground, 3, 5);
    private LinkChrome rolloverChrome = new LinkChrome(this.messageBackground, this.instructionForeground, this.instructionForeground, 6, 5);

    protected LinkChrome getLinkChrome(LinkState linkState) {
        switch (linkState) {
            case SELECTED: {
                return this.selectedChrome;
            }
            case ARMED: {
                return this.armedChrome;
            }
            case ROLLOVER: {
                return this.rolloverChrome;
            }
        }
        return this.selectedChrome;
    }

    @Override
    public void prepareSource(JComponent source) {
        if (source instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)source;
            button.setOpaque(false);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setFocusPainted(false);
        }
    }

    @Override
    public void paint(Graphics g, JComponent source) {
        if (!(source instanceof AbstractButton)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AbstractButton button = (AbstractButton)source;
        if (button.isSelected()) {
            this.getLinkChrome(LinkState.SELECTED).draw(button, g2);
        }
        if (button.getModel().isArmed()) {
            this.getLinkChrome(LinkState.ARMED).draw(button, g2);
        } else if (button.getModel().isRollover()) {
            this.getLinkChrome(LinkState.ROLLOVER).draw(button, g2);
        }
        g2.dispose();
    }

    protected Color normalize(Color color) {
        return color == null ? Color.BLACK : color;
    }

    protected static class LinkChrome {
        private Color startColor;
        private Color endColor;
        private Color borderColor;
        int gradientHeightFactor;
        int arcSize;

        public LinkChrome(Color startColor, Color endColor, Color borderColor, int gradientHeightFactor, int arcSize) {
            this.startColor = startColor;
            this.endColor = endColor;
            this.borderColor = borderColor;
            this.gradientHeightFactor = gradientHeightFactor;
            this.arcSize = arcSize;
        }

        public void draw(AbstractButton button, Graphics2D g) {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, button.getHeight() * this.gradientHeightFactor, this.endColor);
            g.setPaint(paint);
            g.fillRoundRect(0, 0, button.getWidth() - 1, button.getHeight() - 1, this.arcSize, this.arcSize);
            g.setColor(this.borderColor);
            g.drawRoundRect(0, 0, button.getWidth() - 1, button.getHeight() - 1, this.arcSize, this.arcSize);
        }
    }

    protected static enum LinkState {
        SELECTED,
        ARMED,
        ROLLOVER;

    }
}

