/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.dialog.task.design;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.oxbow.swingbits.dialog.task.CommandLink;
import org.oxbow.swingbits.dialog.task.ICommandLinkPainter;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.util.Markup;

public class CommandLinkButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private static final Insets buttonInsets = new Insets(7, 7, 7, 15);
    private final CommandLink link;
    private final ICommandLinkPainter painter;

    public CommandLinkButton(CommandLink link, ICommandLinkPainter painter) {
        this.link = link;
        this.painter = painter;
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
        this.setVerticalAlignment(1);
        this.setVerticalTextPosition(1);
        this.setIconTextGap(7);
        Icon icon = link.getIcon();
        this.setIcon(icon == null ? UIManager.getIcon("TaskDialog.commandLinkIcon") : icon);
        this.setText(this.buildText());
        this.setMargin(buttonInsets);
        if (painter != null) {
            painter.prepareSource(this);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CommandLinkButton.this.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                CommandLinkButton.this.setSelected(false);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialog dlg = TaskDialog.getInstance((Component)e.getSource());
                if (dlg != null) {
                    dlg.setResult(CommandLinkButton.this.link);
                    dlg.setVisible(false);
                }
            }
        });
    }

    private String buildText() {
        String txt = "<html><head><style type='text/css'>p.tdi { %s%s }p.tdt { %s%s }</style></head><p class=\"tdi\">%s</p><p class=\"tdt\">%s</p></html>";
        String instrColorCss = Markup.toCSS(UIManager.getColor("TaskDialog.instructionForeground"));
        return String.format(txt, Markup.toCSS(UIManager.getFont("TaskDialog.instructionFont")), instrColorCss, Markup.toCSS(UIManager.getFont("TaskDialog.textFont")), instrColorCss, Markup.toHTML(this.link.getInstruction(), false), Markup.toHTML(this.link.getText(), false));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.painter != null) {
            this.painter.paint(g, this);
        }
        super.paintComponent(g);
    }
}

