/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.dialog.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.oxbow.swingbits.dialog.task.CommandLink;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.design.CommandLinkButton;
import org.oxbow.swingbits.dialog.task.design.CommandLinkButtonGroup;
import org.oxbow.swingbits.list.CheckList;
import org.oxbow.swingbits.util.Strings;
import org.oxbow.swingbits.util.swing.AncestorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskDialogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDialogs.class);

    private TaskDialogs() {
    }

    public static TaskDialogBuilder build() {
        return new TaskDialogBuilder();
    }

    public static TaskDialogBuilder build(Window parent, String instruction, String text) {
        return TaskDialogs.build().parent(parent).instruction(instruction).text(text);
    }

    public static void inform(Window parent, String instruction, String text) {
        TaskDialogs.build(parent, instruction, text).inform();
    }

    public static void error(Window parent, String instruction, String text) {
        TaskDialogs.build(parent, instruction, text).error();
    }

    public static boolean ask(Window parent, String instruction, String text) {
        return TaskDialogs.build(parent, instruction, text).ask();
    }

    @Deprecated
    public static boolean warn(Window parent, String instruction, String text) {
        return TaskDialogs.build(parent, instruction, text).warn();
    }

    public static boolean isConfirmed(Window parent, String instruction, String text) {
        return TaskDialogs.build(parent, instruction, text).isConfirmed();
    }

    public static void showException(Throwable ex) {
        TaskDialogs.build().showException(ex);
    }

    public static final int radioChoice(Window parent, String instruction, String text, int defaultChoice, List<String> choices) {
        return TaskDialogs.build(parent, instruction, text).radioChoice(defaultChoice, choices);
    }

    public static final int radioChoice(Window parent, String instruction, String text, int defaultChoice, String ... choices) {
        return TaskDialogs.build(parent, instruction, text).radioChoice(defaultChoice, choices);
    }

    public static final int choice(Window parent, String instruction, String text, int defaultChoice, List<CommandLink> choices) {
        return TaskDialogs.build(parent, instruction, text).choice(defaultChoice, choices);
    }

    public static final int choice(Window parent, String instruction, String text, int defaultChoice, CommandLink ... choices) {
        return TaskDialogs.build(parent, instruction, text).choice(defaultChoice, choices);
    }

    public static final <T> T input(Window parent, String instruction, String text, T defaultValue) {
        return TaskDialogs.build(parent, instruction, text).inputColumns(25).input(defaultValue);
    }

    private static TaskDialog messageDialog(Window parent, String title, Icon icon, String instruction, String text) {
        TextWithWaitInterval twi = new TextWithWaitInterval(instruction);
        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(twi.getText());
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg.setCommands(TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey("Close"), twi.getWaitInterval(), twi.getAutoCloseTimeout()));
        return dlg;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {
        TextWithWaitInterval twi = new TextWithWaitInterval(instruction);
        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(twi.getText());
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg.setCommands(TaskDialog.StandardCommand.OK.derive(TaskDialog.makeKey("Yes"), twi.getWaitInterval(), twi.getAutoCloseTimeout()), TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey("No")));
        return dlg;
    }

    private static class TextWithWaitInterval {
        String text;
        int waitInterval = 0;
        int autoCloseTimeout = 0;

        public TextWithWaitInterval(String text) {
            this.text = text;
            int prefixPos = text.indexOf("@@");
            if (prefixPos >= 0) {
                int posAutoClose = text.indexOf("#", prefixPos + "@@".length());
                try {
                    this.waitInterval = Integer.valueOf(text.substring(prefixPos + "@@".length(), posAutoClose < 0 ? text.length() : posAutoClose));
                }
                catch (Throwable ex) {
                    this.waitInterval = 0;
                }
                try {
                    this.autoCloseTimeout = Integer.valueOf(text.substring(posAutoClose + "#".length()));
                }
                catch (Throwable ex) {
                    this.autoCloseTimeout = 0;
                }
                if (this.waitInterval > 0 && this.autoCloseTimeout > this.waitInterval) {
                    LOGGER.warn("Misconfiguration detected: The autoclose value must not be less than the wait value. Current configuration: " + text);
                }
                this.text = text.substring(0, prefixPos);
            }
        }

        public String getText() {
            return this.text;
        }

        public int getWaitInterval() {
            return this.waitInterval;
        }

        public int getAutoCloseTimeout() {
            return this.autoCloseTimeout;
        }
    }

    public static final class TaskDialogBuilder {
        private Window parent = null;
        private String title = null;
        private Icon icon = null;
        private String instruction = null;
        private String text = null;
        private Integer inputColumns = null;
        private boolean alwayOnTop;

        private TaskDialogBuilder() {
        }

        public TaskDialogBuilder parent(Window parent) {
            this.parent = parent;
            return this;
        }

        public TaskDialogBuilder title(String title) {
            this.title = title;
            return this;
        }

        public TaskDialogBuilder icon(Icon icon) {
            this.icon = icon;
            return this;
        }

        public TaskDialogBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public TaskDialogBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TaskDialogBuilder inputColumns(int columns) {
            this.inputColumns = columns;
            return this;
        }

        public TaskDialogBuilder alwaysOnTop() {
            this.alwayOnTop = true;
            return this;
        }

        private boolean isAlwaysOnTop() {
            return this.alwayOnTop;
        }

        private String getTitle(String defaultTitle) {
            return this.title == null ? defaultTitle : this.title;
        }

        private Icon getIcon(Icon defaultIcon) {
            return this.icon == null ? defaultIcon : this.icon;
        }

        public void message() {
            TaskDialogs.messageDialog(this.parent, this.title, this.icon, this.instruction, this.text).setVisible(true);
        }

        public TaskDialog inform() {
            TaskDialog td = TaskDialogs.messageDialog(this.parent, this.getTitle(TaskDialog.makeKey("Information")), this.getIcon(TaskDialog.StandardIcon.INFO), this.instruction, this.text);
            td.setAlwaysOnTop(this.isAlwaysOnTop());
            td.setVisible(true);
            return td;
        }

        public void inform(Consumer<TaskDialog> instanceConsumer) {
            TaskDialog td = TaskDialogs.messageDialog(this.parent, this.getTitle(TaskDialog.makeKey("Information")), this.getIcon(TaskDialog.StandardIcon.INFO), this.instruction, this.text);
            td.setAlwaysOnTop(this.isAlwaysOnTop());
            if (instanceConsumer != null) {
                instanceConsumer.accept(td);
            }
            td.setVisible(true);
        }

        public void error() {
            TaskDialogs.messageDialog(this.parent, this.getTitle(TaskDialog.makeKey("Error")), this.getIcon(TaskDialog.StandardIcon.ERROR), this.instruction, this.text).setVisible(true);
        }

        public void exception(Throwable ex) {
            TaskDialog dlg = TaskDialogs.messageDialog(this.parent, this.getTitle(TaskDialog.makeKey("Error")), this.getIcon(TaskDialog.StandardIcon.ERROR), this.instruction, this.text);
            String msg = ex.getMessage();
            boolean noMessage = Strings.isEmpty(msg);
            JTextArea text = new JTextArea();
            text.setEditable(false);
            text.setFont(UIManager.getFont("Label.font"));
            text.setText(Strings.stackStraceAsString(ex));
            text.setCaretPosition(0);
            JScrollPane scroller = new JScrollPane(text);
            scroller.setPreferredSize(new Dimension(400, 200));
            dlg.getDetails().setExpandableComponent(scroller);
            dlg.getDetails().setExpanded(noMessage);
            dlg.setResizable(true);
            dlg.setVisible(true);
        }

        public boolean ask() {
            return TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Question")), this.getIcon(TaskDialog.StandardIcon.QUESTION), this.instruction, this.text).show().equals(TaskDialog.StandardCommand.OK);
        }

        @Deprecated
        public boolean warn() {
            return TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Warning")), this.getIcon(TaskDialog.StandardIcon.WARNING), this.instruction, this.text).show().equals(TaskDialog.StandardCommand.OK);
        }

        public boolean isConfirmed() {
            return TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Warning")), this.getIcon(TaskDialog.StandardIcon.WARNING), this.instruction, this.text).show().equals(TaskDialog.StandardCommand.OK);
        }

        public void showException(Throwable ex) {
            TaskDialog dlg = new TaskDialog(this.parent, this.getTitle(TaskDialog.makeKey("Exception")));
            String msg = ex.getMessage();
            String className = ex.getClass().getName();
            boolean noMessage = Strings.isEmpty(msg);
            if (this.instruction != null) {
                dlg.setInstruction(this.instruction);
            } else {
                dlg.setInstruction(noMessage ? className : msg);
            }
            if (this.text != null) {
                dlg.setText(this.text);
            } else {
                dlg.setText(noMessage ? "" : className);
            }
            dlg.setIcon(this.getIcon(TaskDialog.StandardIcon.ERROR));
            dlg.setCommands(TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey("Close")));
            JTextArea text = new JTextArea();
            text.setEditable(false);
            text.setFont(UIManager.getFont("Label.font"));
            text.setText(Strings.stackStraceAsString(ex));
            text.setCaretPosition(0);
            JScrollPane scroller = new JScrollPane(text);
            scroller.setPreferredSize(new Dimension(400, 200));
            dlg.getDetails().setExpandableComponent(scroller);
            dlg.getDetails().setExpanded(noMessage);
            dlg.setResizable(true);
            dlg.setVisible(true);
        }

        public int radioChoice(int defaultChoice, List<String> choices) {
            TaskDialog dlg = TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Choice")), null, this.instruction, this.text);
            ButtonGroup bGroup = new ButtonGroup();
            ArrayList<ButtonModel> models = new ArrayList<ButtonModel>();
            JPanel p = new JPanel((LayoutManager)new MigLayout(""));
            for (String c : choices) {
                JRadioButton btn = new JRadioButton(c);
                btn.setOpaque(false);
                models.add(btn.getModel());
                bGroup.add(btn);
                p.add((Component)btn, "dock north");
            }
            if (defaultChoice >= 0 && defaultChoice < choices.size()) {
                bGroup.setSelected((ButtonModel)models.get(defaultChoice), true);
            }
            p.setOpaque(false);
            dlg.setIcon(this.getIcon(TaskDialog.StandardIcon.QUESTION));
            dlg.setFixedComponent(p);
            TextWithWaitInterval twi = new TextWithWaitInterval(this.instruction);
            dlg.setCommands(TaskDialog.StandardCommand.OK.derive(TaskDialog.makeKey("Select"), twi.getWaitInterval(), twi.getAutoCloseTimeout()), TaskDialog.StandardCommand.CANCEL);
            return dlg.show().equals(TaskDialog.StandardCommand.OK) ? models.indexOf(bGroup.getSelection()) : -1;
        }

        public int radioChoice(int defaultChoice, String ... choices) {
            return this.radioChoice(defaultChoice, Arrays.asList(choices));
        }

        public <T> Collection<T> checkChoice(List<T> choices, Collection<T> defaultSelection) {
            TaskDialog dlg = TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Choice")), null, this.instruction, this.text);
            JList list = new JList();
            CheckList<T> checkList = new CheckList.Builder(list).build();
            checkList.setData(choices);
            checkList.setCheckedItems(defaultSelection);
            dlg.setIcon(this.getIcon(TaskDialog.StandardIcon.QUESTION));
            if (choices.size() > 7) {
                dlg.setFixedComponent(new JScrollPane(list));
            } else {
                Color listColor = UIManager.getColor("TaskDialog.messageBackground");
                list.setBackground(listColor);
                list.setSelectionBackground(listColor);
                list.setSelectionForeground(list.getForeground());
                dlg.setFixedComponent(list);
            }
            TextWithWaitInterval twi = new TextWithWaitInterval(this.instruction);
            dlg.setCommands(TaskDialog.StandardCommand.OK.derive(TaskDialog.makeKey("Select"), twi.getWaitInterval(), twi.getAutoCloseTimeout()), TaskDialog.StandardCommand.CANCEL);
            return dlg.show().equals(TaskDialog.StandardCommand.OK) ? checkList.getCheckedItems() : null;
        }

        public int choice(Consumer<TaskDialog> instanceConsumer, final int defaultChoice, List<CommandLink> choices) {
            TaskDialog dlg = TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Choice")), this.getIcon(null), this.instruction, this.text);
            TextWithWaitInterval twi = new TextWithWaitInterval(this.instruction);
            dlg.setCommands(TaskDialog.StandardCommand.CANCEL.derive(TaskDialog.makeKey("Close"), twi.getWaitInterval(), twi.getAutoCloseTimeout()));
            CommandLinkButtonGroup bGroup = new CommandLinkButtonGroup();
            ArrayList<ButtonModel> models = new ArrayList<ButtonModel>();
            final ArrayList<CommandLinkButton> buttons = new ArrayList<CommandLinkButton>();
            JPanel p = new JPanel((LayoutManager)new MigLayout(new LC().flowY().noGrid().fillX()));
            p.setOpaque(false);
            for (CommandLink link : choices) {
                CommandLinkButton btn = new CommandLinkButton(link, TaskDialog.getDesign().getCommandLinkPainter());
                models.add(btn.getModel());
                buttons.add(btn);
                bGroup.add(btn);
                p.add((Component)btn, new CC().growX().gapBottom("8"));
            }
            if (defaultChoice >= 0 && defaultChoice < choices.size()) {
                bGroup.setSelected((ButtonModel)models.get(defaultChoice), true);
                p.addAncestorListener(new AncestorAdapter(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        ((CommandLinkButton)buttons.get(defaultChoice)).requestFocusInWindow();
                    }
                });
            }
            dlg.setFixedComponent(p);
            dlg.setAlwaysOnTop(this.isAlwaysOnTop());
            if (instanceConsumer != null) {
                instanceConsumer.accept(dlg);
            }
            return choices.indexOf(dlg.show());
        }

        public int choice(int defaultChoice, List<CommandLink> choices) {
            return this.choice(null, defaultChoice, choices);
        }

        public int choice(int defaultChoice, CommandLink ... choices) {
            return this.choice(defaultChoice, Arrays.asList(choices));
        }

        public int choice(Consumer<TaskDialog> instanceConsumer, int defaultChoice, CommandLink ... choices) {
            return this.choice(instanceConsumer, defaultChoice, Arrays.asList(choices));
        }

        public <T> T input(T defaultValue) {
            TaskDialog dlg = TaskDialogs.questionDialog(this.parent, this.getTitle(TaskDialog.makeKey("Input")), null, this.instruction, this.text);
            dlg.setIcon(this.getIcon(TaskDialog.StandardIcon.INFO));
            JFormattedTextField tfInput = new JFormattedTextField();
            tfInput.setColumns(this.inputColumns == null ? 25 : this.inputColumns);
            tfInput.setValue(defaultValue);
            dlg.setFixedComponent(tfInput);
            dlg.setCommands(TaskDialog.StandardCommand.OK, TaskDialog.StandardCommand.CANCEL);
            return (T)(dlg.show().equals(TaskDialog.StandardCommand.OK) ? tfInput.getValue() : null);
        }
    }
}

