/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.dialog.task;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.oxbow.swingbits.dialog.task.ContentDesignFactory;
import org.oxbow.swingbits.dialog.task.IContentDesign;
import org.oxbow.swingbits.dialog.task.TaskDialogException;
import org.oxbow.swingbits.dialog.task.design.TaskDialogContent;
import org.oxbow.swingbits.util.Strings;
import org.oxbow.swingbits.util.swing.EmptyIcon;
import org.oxbow.swingbits.util.swing.SwingBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDialog
extends SwingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDialog.class);
    private static final String INSTANCE_PROPERTY = "task.dialog.instance";
    private static final String DEBUG_PROPERTY = "task.dialog.debug";
    public static final String DESIGN_PROPERTY = "task.dialog.design";
    static final String I18N_PREFIX = "@@";
    static final String AUTOCLOSE_PREFIX = "#";
    private static final String LOCALE_BUNDLE_NAME = "task-dialog";
    private static IContentDesign design = TaskDialog.prepareDesign();
    private static final KeyStroke KS_ESCAPE;
    private static final KeyStroke KS_ENTER;
    private static final KeyStroke KS_F1;
    private final SwingBean.Property<String> instruction = new SwingBean.Property<String>("instruction"){

        @Override
        public String get() {
            return TaskDialog.this.content.getInstruction();
        }

        @Override
        protected void setValue(String instruction) {
            TaskDialog.this.content.setInstruction(instruction);
        }
    };
    private final SwingBean.Property<String> text = new SwingBean.Property<String>("text"){

        @Override
        public String get() {
            return TaskDialog.this.content.getMainText();
        }

        @Override
        protected void setValue(String text) {
            TaskDialog.this.content.setMainText(text);
        }
    };
    private final SwingBean.Property<Boolean> visible = new SwingBean.Property<Boolean>("visible"){

        @Override
        public Boolean get() {
            return TaskDialog.this.dlg.isVisible();
        }

        @Override
        protected void setValue(Boolean visible) {
            LOGGER.info("Change the visible property: {}", (Object)visible);
            if (visible.booleanValue()) {
                TaskDialog.this.content.setCommands(TaskDialog.this.commands, TaskDialog.getDesign().isCommandButtonSizeLocked());
            }
        }

        @Override
        protected void postSetAction(Boolean visible) {
            LOGGER.debug("Run the set action, visible: {}", (Object)visible);
            if (visible.booleanValue()) {
                LOGGER.info("Show the task dialog.");
                TaskDialog.this.dlg.pack();
                Window window = TaskDialog.this.dlg.getOwner();
                if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) != null && !window.isDisplayable()) {
                    window = null;
                }
                TaskDialog.this.dlg.setLocationRelativeTo(window);
                TaskDialog.this.dlg.setVisible(true);
            } else {
                LOGGER.info("Hide the task dialog.");
                TaskDialog.this.dlg.setVisible(false);
                TaskDialog.this.dlg.dispose();
                LOGGER.info("Hide the task dialog finished.");
            }
        }
    };
    private final SwingBean.Property<Icon> icon = new SwingBean.Property<Icon>("icon"){

        @Override
        public Icon get() {
            return TaskDialog.this.content.getMainIcon();
        }

        @Override
        protected void setValue(Icon icon) {
            TaskDialog.this.content.setMainIcon(icon);
        }
    };
    private final SwingBean.Property<Command> result = new SwingBean.Property<Command>("result", true){
        private Command value;
        {
            this.value = StandardCommand.CANCEL;
        }

        @Override
        public Command get() {
            return this.value;
        }

        @Override
        protected void setValue(Command command) {
            this.value = command;
        }
    };
    private Locale resourceBundleLocale = null;
    private ResourceBundle resourceBundle = null;
    private final JDialog dlg;
    private final TaskDialogContent content;
    private Set<Command> commands = new LinkedHashSet<StandardCommand>(Arrays.asList(StandardCommand.OK));
    private final List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    private static IContentDesign prepareDesign() {
        String property = System.getProperty(DESIGN_PROPERTY);
        if (property != null) {
            try {
                return (IContentDesign)Class.forName(property).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new TaskDialogException("Could not instantiate content design: " + property, ex);
            }
        }
        return ContentDesignFactory.getDesignByOperatingSystem();
    }

    static final IContentDesign getDesign() {
        return design;
    }

    public static final String makeKey(String text) {
        return I18N_PREFIX + text;
    }

    public static final TaskDialog getInstance(Component source) {
        Window w = SwingUtilities.getWindowAncestor(source);
        if (w instanceof JDialog) {
            JComponent c = (JComponent)((JDialog)w).getContentPane();
            return (TaskDialog)c.getClientProperty(INSTANCE_PROPERTY);
        }
        return null;
    }

    public static final void setDebugMode(boolean debug) {
        if (debug) {
            System.setProperty(DEBUG_PROPERTY, "true");
        } else {
            System.clearProperty(DEBUG_PROPERTY);
        }
    }

    public static final boolean isDebugMode() {
        return System.getProperty(DEBUG_PROPERTY) != null;
    }

    public TaskDialog(Window parent, String title) {
        Window pWnd = parent;
        if (pWnd == null) {
            for (pWnd = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); pWnd != null && !pWnd.isVisible() && pWnd.getParent() != null; pWnd = (Window)pWnd.getParent()) {
            }
        }
        this.dlg = new JDialog(pWnd);
        if (pWnd != null) {
            this.dlg.setIconImages(pWnd.getIconImages());
        }
        this.dlg.setMinimumSize(new Dimension(300, 150));
        this.setResizable(false);
        this.setModalityType(JDialog.DEFAULT_MODALITY_TYPE);
        this.dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TaskDialog.this.result.set(StandardCommand.CANCEL);
            }
        });
        this.setTitle(title);
        this.content = design.buildContent();
        this.dlg.setContentPane(this.content);
        JComponent c = (JComponent)this.dlg.getContentPane();
        c.putClientProperty(INSTANCE_PROPERTY, this);
    }

    public Dialog.ModalityType getModalityType() {
        return this.dlg.getModalityType();
    }

    public void setModalityType(Dialog.ModalityType modalityType) {
        this.dlg.setModalityType(modalityType);
    }

    public boolean iAlwaysOnTop() {
        return this.dlg.isAlwaysOnTop();
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.dlg.setAlwaysOnTop(alwaysOnTop);
    }

    public boolean isResizable() {
        return this.dlg.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.dlg.setResizable(resizable);
    }

    public final void addValidationListener(ValidationListener listener) {
        if (listener != null) {
            this.validationListeners.add(listener);
        }
    }

    public final void removeValidationListener(ValidationListener listener) {
        if (listener != null) {
            this.validationListeners.remove(listener);
        }
    }

    public final void fireValidationFinished(boolean validationResult) {
        ListIterator<ValidationListener> iter = this.validationListeners.listIterator(this.validationListeners.size());
        while (iter.hasPrevious()) {
            iter.previous().validationFinished(validationResult);
        }
    }

    public Locale getLocale() {
        return this.dlg.getLocale();
    }

    public void setLocale(Locale locale) {
        this.dlg.setLocale(locale);
    }

    private final synchronized ResourceBundle getLocaleBundle() {
        Locale currentLocale = this.getLocale();
        if (!currentLocale.equals(this.resourceBundleLocale)) {
            this.resourceBundleLocale = currentLocale;
            this.resourceBundle = ResourceBundle.getBundle(LOCALE_BUNDLE_NAME, this.resourceBundleLocale, this.getClass().getClassLoader());
        }
        return this.resourceBundle;
    }

    public String getLocalizedString(String key) {
        try {
            return this.getLocaleBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            return String.format("<%s>", key);
        }
    }

    public String getString(String text) {
        return text != null && text.startsWith(I18N_PREFIX) ? this.getLocalizedString(text.substring(I18N_PREFIX.length())) : text;
    }

    public Object getClientProperty(Object key) {
        return this.dlg.getRootPane().getClientProperty(key);
    }

    public void putClientProperty(Object key, Object value) {
        this.dlg.getRootPane().putClientProperty(key, value);
    }

    public void setVisible(boolean visible) {
        this.visible.set(visible);
    }

    public boolean isVisible() {
        return (Boolean)this.visible.get();
    }

    public Command getResult() {
        return (Command)this.result.get();
    }

    public void setResult(Command result) {
        this.result.set(result);
    }

    public Command show() {
        this.setVisible(true);
        return this.getResult();
    }

    public String toString() {
        return this.getTitle();
    }

    public String getTitle() {
        return this.dlg.getTitle();
    }

    public void setTitle(String title) {
        this.dlg.setTitle(this.getString(title));
    }

    public void setIcon(Icon icon) {
        this.icon.set(icon);
    }

    public Icon getIcon() {
        return (Icon)this.icon.get();
    }

    public void setInstruction(String instruction) {
        this.instruction.set(instruction);
    }

    public String getInstruction() {
        return (String)this.instruction.get();
    }

    public void setText(String text) {
        this.text.set(text);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public void setFixedComponent(JComponent c) {
        this.content.setComponent(c);
    }

    public JComponent getFixedComponent() {
        return this.content.getComponent();
    }

    public Details getDetails() {
        return this.content;
    }

    public Footer getFooter() {
        return this.content;
    }

    public void setCommands(Collection<Command> commands) {
        this.commands = new LinkedHashSet<Command>(commands);
    }

    public void setCommands(Command ... commands) {
        this.setCommands(Arrays.asList(commands));
    }

    public Collection<Command> getCommands() {
        return this.commands;
    }

    public boolean isCommandsVisible() {
        return this.content.isCommandsVisible();
    }

    public void setCommandsVisible(boolean visible) {
        this.content.setCommandsVisible(visible);
    }

    static {
        TaskDialog.getDesign().updateUIDefaults();
        KS_ESCAPE = KeyStroke.getKeyStroke(27, 0);
        KS_ENTER = KeyStroke.getKeyStroke(10, 0);
        KS_F1 = KeyStroke.getKeyStroke(112, 0);
    }

    public static interface Footer {
        public boolean isCheckBoxSelected();

        public void setCheckBoxSelected(boolean var1);

        public String getCheckBoxText();

        public void setCheckBoxText(String var1);

        public Icon getIcon();

        public void setIcon(Icon var1);

        public String getText();

        public void setText(String var1);
    }

    public static interface Details {
        public String getCollapsedLabel();

        public void setCollapsedLabel(String var1);

        public String getExpandedLabel();

        public void setExpandedLabel(String var1);

        public boolean isExpanded();

        public void setExpanded(boolean var1);

        public void setAlwaysExpanded(boolean var1);

        public boolean isAlwaysExpanded();

        public JComponent getExpandableComponent();

        public void setExpandableComponent(JComponent var1);
    }

    public static abstract class CustomCommand
    implements Command {
        private final StandardCommand command;

        public CustomCommand(StandardCommand command) {
            if (command == null) {
                throw new IllegalArgumentException("Command should not be null");
            }
            this.command = command;
        }

        @Override
        public String getDescription() {
            return this.command.getDescription();
        }

        @Override
        public CommandTag getTag() {
            return this.command.getTag();
        }

        @Override
        public String getTitle() {
            return this.command.getTitle();
        }

        @Override
        public boolean isClosing() {
            return this.command.isClosing();
        }

        @Override
        public int getAutoCloseTimeout() {
            return this.command.getAutoCloseTimeout();
        }

        @Override
        public int getWaitInterval() {
            return this.command.getWaitInterval();
        }

        @Override
        public boolean isEnabled(boolean validationResult) {
            return this.command.isEnabled(validationResult);
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean validationResult) {
            this.command.isEnabled(validationResult);
        }

        public boolean equals(Object obj) {
            return this.command.equals(obj);
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        @Override
        public KeyStroke getKeyStroke() {
            return this.command.getKeyStroke();
        }
    }

    public static enum StandardCommand implements Command
    {
        OK(CommandTag.OK),
        CANCEL(CommandTag.CANCEL);

        private final CommandTag tag;

        private StandardCommand(CommandTag tag) {
            this.tag = tag;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public CommandTag getTag() {
            return this.tag;
        }

        @Override
        public String getTitle() {
            return this.tag.getDefaultTitle();
        }

        @Override
        public boolean isClosing() {
            return this.tag.isClosing();
        }

        @Override
        public int getAutoCloseTimeout() {
            return 0;
        }

        @Override
        public int getWaitInterval() {
            return 0;
        }

        @Override
        public boolean isEnabled(boolean validationResult) {
            return this.tag.isEnabled(validationResult);
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean validationResult) {
            this.tag.isEnabled(validationResult);
        }

        @Override
        public KeyStroke getKeyStroke() {
            return this.tag.getDefaultKeyStroke();
        }

        public Command derive(final String title, final int waitInterval, final int autoCloseTimeout) {
            return new CustomCommand(this){

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int getWaitInterval() {
                    return waitInterval;
                }

                @Override
                public int getAutoCloseTimeout() {
                    return autoCloseTimeout;
                }
            };
        }

        public Command derive(final String title) {
            return new CustomCommand(this){

                @Override
                public String getTitle() {
                    return title;
                }
            };
        }
    }

    public static interface Command {
        public String getTitle();

        public CommandTag getTag();

        public String getDescription();

        public boolean isClosing();

        public int getWaitInterval();

        public int getAutoCloseTimeout();

        public boolean isEnabled(boolean var1);

        public KeyStroke getKeyStroke();
    }

    public static interface ValidationListener {
        public void validationFinished(boolean var1);
    }

    public static enum CommandTag {
        OK("ok", KS_ENTER, true, true),
        CANCEL("cancel", KS_ESCAPE, true),
        HELP("help", KS_F1, false),
        HELP2("help2", "Help", KS_F1, false),
        YES("yes", KS_ENTER, true, true),
        NO("no", KS_ESCAPE, true),
        APPLY("apply"),
        NEXT("next", true, false),
        BACK("back"),
        FINISH("finish", KS_ENTER, true, true),
        LEFT("left"),
        RIGHT("right");

        private String tag;
        private final String defaultTitle;
        private boolean useValidationResult = false;
        private boolean closing;
        private KeyStroke defaultKeyStroke;

        private CommandTag(String tag, String defaultTitle, KeyStroke defaultKeyStroke, boolean useValidationResult, boolean closing) {
            this.tag = "tag " + tag;
            this.defaultTitle = TaskDialog.makeKey(Strings.isEmpty(defaultTitle) ? Strings.capitalize(tag) : defaultTitle);
            this.useValidationResult = useValidationResult;
            this.closing = closing;
            this.defaultKeyStroke = defaultKeyStroke;
        }

        private CommandTag(String tag, String defaultTitle, KeyStroke defaultKeyStroke, boolean closing) {
            this(tag, defaultTitle, defaultKeyStroke, false, closing);
        }

        private CommandTag(String tag, KeyStroke defaultKeyStroke, boolean closing) {
            this(tag, null, defaultKeyStroke, false, closing);
        }

        private CommandTag(String tag, boolean closing) {
            this(tag, null, closing);
        }

        private CommandTag(String tag) {
            this(tag, false);
        }

        private CommandTag(String tag, KeyStroke defaultKeyStroke, boolean useValidationResult, boolean closing) {
            this(tag, null, defaultKeyStroke, useValidationResult, closing);
        }

        private CommandTag(String tag, boolean useValidationResult, boolean closing) {
            this(tag, null, useValidationResult, closing);
        }

        public String getDefaultTitle() {
            return this.defaultTitle;
        }

        public String toString() {
            return this.tag;
        }

        public boolean isEnabled(boolean validationResult) {
            return this.useValidationResult ? validationResult : true;
        }

        public boolean isClosing() {
            return this.closing;
        }

        public KeyStroke getDefaultKeyStroke() {
            return this.defaultKeyStroke;
        }
    }

    public static enum StandardIcon implements Icon
    {
        INFO("OptionPane.informationIcon"),
        QUESTION("OptionPane.questionIcon"),
        WARNING("OptionPane.warningIcon"),
        ERROR("OptionPane.errorIcon");

        private final String key;
        private Icon emptyIcon;

        private StandardIcon(String key) {
            this.key = key;
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getIcon().paintIcon(c, g, x, y);
        }

        private synchronized Icon getIcon() {
            Icon icon = UIManager.getIcon(this.key);
            return icon == null ? this.getEmptyIcon() : icon;
        }

        private synchronized Icon getEmptyIcon() {
            if (this.emptyIcon == null) {
                this.emptyIcon = EmptyIcon.hidden();
            }
            return this.emptyIcon;
        }
    }
}

