/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.action;

import java.awt.Component;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.oxbow.swingbits.action.ActionDropDownMenu;
import org.oxbow.swingbits.action.ActionGroup;
import org.oxbow.swingbits.action.Actions;
import org.oxbow.swingbits.action.CheckAction;
import org.oxbow.swingbits.action.RadioAction;

class ActionBuilderHelper {
    ActionBuilderHelper() {
    }

    protected <T> T createGroup(MenuAdapter<T> menu, Collection<Action> actions) {
        int item = 1;
        int size = actions.size();
        for (Action a : actions) {
            this.createAction(menu, a, item++ == size);
        }
        return menu.get();
    }

    private <T> T createAction(MenuAdapter<T> menu, Action a, boolean isLast) {
        if (a instanceof Collection) {
            if (this.isCollapsed(a)) {
                JMenu m = this.createGroup(new JMenuAdapter(new JMenu(a)), (Collection)((Object)a));
                menu.add(m);
            } else {
                menu.addSeparator();
                this.createGroup(menu, (Collection)((Object)a));
                if (!isLast) {
                    menu.addSeparator();
                }
            }
        } else if (Actions.isSeparator(a)) {
            if (!isLast) {
                menu.addSeparator();
            }
        } else if (this.isCheckAction(a)) {
            menu.add(new JCheckBoxMenuItem(this.prepareCheckAction(a)));
        } else if (this.isRadioAction(a)) {
            JMenuItem item = menu.add(new JRadioButtonMenuItem(this.prepareCheckAction(a)));
            menu.getButtonGroup().add(item);
        } else {
            menu.add(new JMenuItem(a));
        }
        return menu.get();
    }

    private Action prepareCheckAction(Action a) {
        if (a.getValue("SwingSelectedKey") == null) {
            a.putValue("SwingSelectedKey", Boolean.FALSE);
        }
        return a;
    }

    private boolean isCheckAction(Action a) {
        return a.getClass().getAnnotation(CheckAction.class) != null;
    }

    private boolean isRadioAction(Action a) {
        return a.getClass().getAnnotation(RadioAction.class) != null;
    }

    private boolean isCollapsed(Action a) {
        return a instanceof ActionGroup && ((ActionGroup)a).isCollapsed();
    }

    class JMenuAdapter
    extends MenuAdapter<JMenu> {
        public JMenuAdapter(JMenu menu) {
            super(menu);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            ((JMenu)this.target).add(menuItem);
            return menuItem;
        }

        @Override
        public void addSeparator() {
            boolean canAddSeparator;
            int count = ((JMenu)this.target).getMenuComponentCount();
            boolean bl = canAddSeparator = count != 0 && ((JMenu)this.target).getMenuComponent(count - 1).getClass() != JPopupMenu.Separator.class;
            if (canAddSeparator) {
                ((JMenu)this.target).addSeparator();
            }
        }
    }

    class JPopupMenuAdapter
    extends MenuAdapter<JPopupMenu> {
        public JPopupMenuAdapter(JPopupMenu menu) {
            super(menu);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            ((JPopupMenu)this.target).add(menuItem);
            return menuItem;
        }

        @Override
        public void addSeparator() {
            boolean canAddSeparator;
            int count = ((JPopupMenu)this.target).getComponentCount();
            boolean bl = canAddSeparator = count != 0 && ((JPopupMenu)this.target).getComponent(count - 1).getClass() != JPopupMenu.Separator.class;
            if (canAddSeparator) {
                ((JPopupMenu)this.target).addSeparator();
            }
        }
    }

    class JToolBarAdapter
    extends MenuAdapter<JToolBar> {
        public JToolBarAdapter(JToolBar tb) {
            super(tb);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            Action action = menuItem.getAction();
            AbstractButton b = this.add(action, menuItem);
            b.setHorizontalTextPosition(10);
            b.putClientProperty("hideActionText", action.getValue("SmallIcon") != null);
            return menuItem;
        }

        private AbstractButton add(Action action, JMenuItem item) {
            if (item instanceof JCheckBoxMenuItem || item instanceof JRadioButtonMenuItem) {
                return (AbstractButton)((JToolBar)this.target).add(new JToggleButton(action));
            }
            if (item instanceof JMenu) {
                return ((JToolBar)this.target).add(new ActionDropDownMenu((ActionGroup)action));
            }
            return ((JToolBar)this.target).add(action);
        }
    }

    class JMenuBarAdapter
    extends MenuAdapter<JMenuBar> {
        public JMenuBarAdapter(JMenuBar mb) {
            super(mb);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            Component c = ((JMenuBar)this.target).add(menuItem);
            if (c instanceof JMenu) {
                ((JMenu)c).setIcon(null);
            }
            return menuItem;
        }
    }

    abstract class MenuAdapter<T> {
        protected T target;
        private ButtonGroup bg;

        public MenuAdapter(T target) {
            this.target = target;
        }

        public T get() {
            return this.target;
        }

        public void addSeparator() {
        }

        public ButtonGroup getButtonGroup() {
            if (this.bg == null) {
                this.bg = new ButtonGroup();
            }
            return this.bg;
        }

        public abstract JMenuItem add(JMenuItem var1);
    }
}

