/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.security.IJadxSecurity;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ResourceStorage {
    private static final Comparator<ResourceEntry> RES_ENTRY_NAME_COMPARATOR = Comparator.comparing(ResourceEntry::getConfig).thenComparing(ResourceEntry::getTypeName).thenComparing(ResourceEntry::getKeyName);
    private final List<ResourceEntry> list = new ArrayList<ResourceEntry>();
    private final IJadxSecurity security;
    private String appPackage;
    private final Map<ResourceEntry, ResourceEntry> uniqNameEntries = new TreeMap<ResourceEntry, ResourceEntry>(RES_ENTRY_NAME_COMPARATOR);
    private final Map<Integer, String> renames = new HashMap<Integer, String>();

    public ResourceStorage(IJadxSecurity security) {
        this.security = security;
    }

    public void add(ResourceEntry resEntry) {
        this.list.add(resEntry);
        this.uniqNameEntries.put(resEntry, resEntry);
    }

    public void replace(ResourceEntry prevResEntry, ResourceEntry newResEntry) {
        int idx = this.list.indexOf(prevResEntry);
        if (idx != -1) {
            this.list.set(idx, newResEntry);
        }
    }

    public void addRename(ResourceEntry entry) {
        this.addRename(entry.getId(), entry.getKeyName());
    }

    public void addRename(int id, String keyName) {
        this.renames.put(id, keyName);
    }

    public String getRename(int id) {
        return this.renames.get(id);
    }

    public ResourceEntry searchEntryWithSameName(ResourceEntry resourceEntry) {
        return this.uniqNameEntries.get(resourceEntry);
    }

    public void finish() {
        this.list.sort(Comparator.comparingInt(ResourceEntry::getId));
        this.uniqNameEntries.clear();
        this.renames.clear();
    }

    public int size() {
        return this.list.size();
    }

    public Iterable<ResourceEntry> getResources() {
        return this.list;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = this.security.verifyAppPackage(appPackage);
    }

    public Map<Integer, String> getResourcesNames() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (ResourceEntry entry : this.list) {
            map.put(entry.getId(), entry.getTypeName() + "/" + entry.getKeyName());
        }
        return map;
    }
}

