/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.xmlgen.BinaryXMLStrings;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ParserStream;
import java.io.IOException;

public class CommonBinaryParser
extends ParserConstants {
    protected ParserStream is;

    protected BinaryXMLStrings parseStringPool() throws IOException {
        this.is.checkInt16(1, "String pool expected");
        return this.parseStringPoolNoType();
    }

    protected BinaryXMLStrings parseStringPoolNoType() throws IOException {
        long start = this.is.getPos() - 2L;
        this.is.checkInt16(28, "String pool header size not 0x001c");
        long size = this.is.readUInt32();
        long chunkEnd = start + size;
        int stringCount = this.is.readInt32();
        int styleCount = this.is.readInt32();
        int flags = this.is.readInt32();
        long stringsStart = this.is.readInt32();
        long stylesStart = this.is.readInt32();
        byte[] buffer = this.is.readInt8Array((int)(chunkEnd - this.is.getPos()));
        this.is.checkPos(chunkEnd, "Expected strings pool end");
        return new BinaryXMLStrings(stringCount, stringsStart -= this.is.getPos() - start, buffer, (flags & 0x100) != 0);
    }

    protected void die(String message) throws IOException {
        throw new IOException("Decode error: " + message + ", position: 0x" + Long.toHexString(this.is.getPos()));
    }
}

