/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.blocks;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.EmptyBitSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class BlockSet {
    private final MethodNode mth;
    private final BitSet bs;

    public static BlockSet from(MethodNode mth, Collection<BlockNode> blocks) {
        BlockSet newBS = new BlockSet(mth);
        newBS.set(blocks);
        return newBS;
    }

    public BlockSet(MethodNode mth) {
        this.mth = mth;
        this.bs = new BitSet(mth.getBasicBlocks().size());
    }

    public boolean get(BlockNode block) {
        return this.bs.get(block.getId());
    }

    public void set(BlockNode block) {
        this.bs.set(block.getId());
    }

    public void set(Collection<BlockNode> blocks) {
        blocks.forEach(this::set);
    }

    public boolean checkAndSet(BlockNode block) {
        int id = block.getId();
        boolean state = this.bs.get(id);
        this.bs.set(id);
        return state;
    }

    public boolean intersects(List<BlockNode> blocks) {
        for (BlockNode block : blocks) {
            if (!this.get(block)) continue;
            return true;
        }
        return false;
    }

    public BlockSet intersect(List<BlockNode> blocks) {
        BlockSet input = BlockSet.from(this.mth, blocks);
        BlockSet result = new BlockSet(this.mth);
        BitSet resultBS = result.bs;
        resultBS.or(this.bs);
        resultBS.and(input.bs);
        return result;
    }

    public boolean isEmpty() {
        return this.bs.cardinality() == 0;
    }

    public int size() {
        return this.bs.cardinality();
    }

    @Nullable
    public BlockNode getOne() {
        if (this.bs.cardinality() == 1) {
            return this.mth.getBasicBlocks().get(this.bs.nextSetBit(0));
        }
        return null;
    }

    public void forEach(Consumer<? super BlockNode> consumer) {
        if (this.bs.isEmpty()) {
            return;
        }
        List<BlockNode> blocks = this.mth.getBasicBlocks();
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            consumer.accept(blocks.get(i));
            i = this.bs.nextSetBit(i + 1);
        }
    }

    public List<BlockNode> toList() {
        if (this.bs == null || this.bs == EmptyBitSet.EMPTY) {
            return Collections.emptyList();
        }
        int size = this.bs.cardinality();
        if (size == 0) {
            return Collections.emptyList();
        }
        List<BlockNode> mthBlocks = this.mth.getBasicBlocks();
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(size);
        int i = this.bs.nextSetBit(0);
        while (i >= 0) {
            blocks.add(mthBlocks.get(i));
            i = this.bs.nextSetBit(i + 1);
        }
        return blocks;
    }

    public String toString() {
        return this.toList().toString();
    }
}

