/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.utils.ImmutableList;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final String JADX_API_PACKAGE = JadxDecompiler.class.getPackage().getName();
    private static final String STACKTRACE_STOP_CLS_NAME = DepthTraversal.class.getName();

    private Utils() {
    }

    public static String cleanObjectName(String obj) {
        int last;
        if (obj.charAt(0) == 'L' && obj.charAt(last = obj.length() - 1) == ';') {
            return obj.substring(1, last).replace('/', '.');
        }
        return obj;
    }

    public static String cutObject(String obj) {
        if (obj.charAt(0) == 'L') {
            return obj.substring(1, obj.length() - 1);
        }
        return obj;
    }

    public static String makeQualifiedObjectName(String obj) {
        return "L" + obj.replace('.', '/') + ";";
    }

    public static String strRepeat(String str, int count) {
        if (count < 1) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String listToString(Iterable<?> objects) {
        return Utils.listToString(objects, ", ");
    }

    public static String listToString(Iterable<?> objects, String joiner) {
        if (objects == null) {
            return "";
        }
        return Utils.listToString(objects, joiner, Objects::toString);
    }

    public static <T> String listToString(Iterable<T> objects, Function<T, String> toStr) {
        return Utils.listToString(objects, ", ", toStr);
    }

    public static <T> String listToString(Iterable<T> objects, String joiner, Function<T, String> toStr) {
        StringBuilder sb = new StringBuilder();
        Utils.listToString(sb, objects, joiner, toStr);
        return sb.toString();
    }

    public static <T> void listToString(StringBuilder sb, Iterable<T> objects, String joiner) {
        Utils.listToString(sb, objects, joiner, Objects::toString);
    }

    public static <T> void listToString(StringBuilder sb, Iterable<T> objects, String joiner, Function<T, String> toStr) {
        if (objects == null) {
            return;
        }
        Iterator<T> it = objects.iterator();
        if (it.hasNext()) {
            sb.append(toStr.apply(it.next()));
        }
        while (it.hasNext()) {
            sb.append(joiner).append(toStr.apply(it.next()));
        }
    }

    public static <T> String arrayToStr(T[] arr) {
        int len;
        int n = len = arr == null ? 0 : arr.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(arr[0]);
        for (int i = 1; i < len; ++i) {
            sb.append(", ").append(arr[i]);
        }
        return sb.toString();
    }

    public static String concatStrings(List<String> list) {
        if (Utils.isEmpty(list)) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder sb = new StringBuilder();
        list.forEach(sb::append);
        return sb.toString();
    }

    public static String currentStackTrace() {
        return Utils.getStackTrace(new Exception());
    }

    public static String currentStackTrace(int skipFrames) {
        Exception e = new Exception();
        StackTraceElement[] stackTrace = e.getStackTrace();
        int len = stackTrace.length;
        if (skipFrames < len) {
            e.setStackTrace(Arrays.copyOfRange(stackTrace, skipFrames, len));
        }
        return Utils.getStackTrace(e);
    }

    public static String getFullStackTrace(Throwable throwable) {
        return Utils.getStackTrace(throwable, false);
    }

    public static String getStackTrace(Throwable throwable) {
        return Utils.getStackTrace(throwable, true);
    }

    private static String getStackTrace(Throwable throwable, boolean filter) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (filter) {
            Utils.filterRecursive(throwable);
        }
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static void appendStackTrace(final ICodeWriter code, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        code.startLine();
        OutputStream w = new OutputStream(){

            @Override
            public void write(int b) {
                char c = (char)b;
                switch (c) {
                    case '\n': {
                        code.startLine();
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    default: {
                        code.add(c);
                    }
                }
            }
        };
        try (PrintWriter pw = new PrintWriter(w, true);){
            Utils.filterRecursive(throwable);
            throwable.printStackTrace(pw);
            pw.flush();
        }
    }

    private static void filterRecursive(Throwable th) {
        try {
            Utils.filter(th);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable cause = th.getCause();
        if (cause != null) {
            Utils.filterRecursive(cause);
        }
    }

    private static void filter(Throwable th) {
        int i;
        StackTraceElement[] stackTrace = th.getStackTrace();
        int length = stackTrace.length;
        StackTraceElement prevElement = null;
        for (i = 0; i < length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String clsName = stackTraceElement.getClassName();
            if (clsName.equals(STACKTRACE_STOP_CLS_NAME) || clsName.startsWith(JADX_API_PACKAGE) || Objects.equals(prevElement, stackTraceElement)) {
                th.setStackTrace(Arrays.copyOfRange(stackTrace, 0, i));
                return;
            }
            prevElement = stackTraceElement;
        }
        for (i = length - 1; i >= 0; --i) {
            String clsName = stackTrace[i].getClassName();
            if (!clsName.startsWith("jadx.") || clsName.startsWith("jadx.tests.")) continue;
            th.setStackTrace(Arrays.copyOfRange(stackTrace, 0, i));
            return;
        }
    }

    public static <T, R> List<R> collectionMap(Collection<T> list, Function<T, R> mapFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T t : list) {
            result.add(mapFunc.apply(t));
        }
        return result;
    }

    public static <T, R> List<R> collectionMapNoNull(Collection<T> list, Function<T, R> mapFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> result = new ArrayList<R>(list.size());
        for (T t : list) {
            R r = mapFunc.apply(t);
            if (r == null) continue;
            result.add(r);
        }
        return result;
    }

    public static <T> boolean containsInListByRef(List<T> list, T element) {
        if (Utils.isEmpty(list)) {
            return false;
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexInListByRef(List<T> list, T element) {
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (t != element) continue;
            return i;
        }
        return -1;
    }

    public static <T> List<T> lockList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        return new ImmutableList<T>(list);
    }

    public static <T> List<T> listTail(List<T> list, int startIndex) {
        if (startIndex == 0) {
            return list;
        }
        int size = list.size();
        if (startIndex >= size) {
            return Collections.emptyList();
        }
        return list.subList(startIndex, size);
    }

    public static <T> List<T> mergeLists(List<T> first, List<T> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        ArrayList<T> result = new ArrayList<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static <T> Set<T> mergeSets(Set<T> first, Set<T> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        HashSet<T> result = new HashSet<T>(first.size() + second.size());
        result.addAll(first);
        result.addAll(second);
        return result;
    }

    public static Map<String, String> newConstStringMap(String ... parameters) {
        int len = parameters.length;
        if (len == 0) {
            return Collections.emptyMap();
        }
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Incorrect arguments count: " + len);
        }
        HashMap<String, String> result = new HashMap<String, String>(len / 2);
        for (int i = 0; i < len - 1; i += 2) {
            result.put(parameters[i], parameters[i + 1]);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> first, Map<K, V> second) {
        if (Utils.isEmpty(first)) {
            return second;
        }
        if (Utils.isEmpty(second)) {
            return first;
        }
        HashMap<K, V> result = new HashMap<K, V>(first.size() + second.size());
        result.putAll(first);
        result.putAll(second);
        return result;
    }

    public static <K, V> Map<K, V> groupBy(List<V> list, Function<V, K> mapKey) {
        HashMap<K, V> map = new HashMap<K, V>(list.size());
        for (V v : list) {
            map.put(mapKey.apply(v), v);
        }
        return map;
    }

    public static <T> void treeDfsVisit(T root, Function<T, List<T>> childrenProvider, Consumer<T> visitor) {
        Utils.multiRootTreeDfsVisit(Collections.singletonList(root), childrenProvider, visitor);
    }

    public static <T> void multiRootTreeDfsVisit(List<T> roots, Function<T, List<T>> childrenProvider, Consumer<T> visitor) {
        ArrayDeque<T> queue = new ArrayDeque<T>(roots);
        Object current;
        block0: while ((current = queue.pollLast()) != null) {
            visitor.accept(current);
            Iterator<T> iterator = childrenProvider.apply(current).iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                T child = iterator.next();
                queue.addLast(child);
            }
            break;
        }
        return;
    }

    @Nullable
    public static <T> T getOne(@Nullable List<T> list) {
        if (list == null || list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static <T> T getOne(@Nullable Collection<T> collection) {
        if (collection == null || collection.size() != 1) {
            return null;
        }
        return collection.iterator().next();
    }

    @Nullable
    public static <T> T first(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Nullable
    public static <T> T first(Iterable<T> list) {
        Iterator<T> it = list.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return it.next();
    }

    @Nullable
    public static <T> T last(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Nullable
    public static <T> T last(Iterable<T> list) {
        T next;
        Iterator<T> it = list.iterator();
        if (!it.hasNext()) {
            return null;
        }
        do {
            next = it.next();
        } while (it.hasNext());
        return next;
    }

    public static <T> T getOrElse(@Nullable T obj, T defaultObj) {
        if (obj == null) {
            return defaultObj;
        }
        return obj;
    }

    public static <T> boolean isEmpty(Collection<T> col) {
        return col == null || col.isEmpty();
    }

    public static <T> boolean notEmpty(Collection<T> col) {
        return col != null && !col.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }

    public static <T> boolean notEmpty(T[] arr) {
        return arr != null && arr.length != 0;
    }

    public static void checkThreadInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            throw new JadxRuntimeException("Thread interrupted");
        }
    }

    @Deprecated
    public static boolean getEnvVarBool(String varName, boolean defValue) {
        String strValue = System.getenv(varName);
        if (strValue == null) {
            return defValue;
        }
        return strValue.equalsIgnoreCase("true");
    }

    @Deprecated
    public static int getEnvVarInt(String varName, int defValue) {
        String strValue = System.getenv(varName);
        if (strValue == null) {
            return defValue;
        }
        return Integer.parseInt(strValue);
    }
}

