/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;

@JadxVisitor(name="CheckCode", desc="Check and remove bad or incorrect code")
public class CheckCode
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        MethodInfo mthInfo = mth.getMethodInfo();
        if (mthInfo.getArgumentsTypes().size() > 255 && this.canRemoveMethod(mth)) {
            mth.ignoreMethod();
        }
        this.checkInstructions(mth);
    }

    private boolean canRemoveMethod(MethodNode mth) {
        if (mth.getUseIn().isEmpty()) {
            return true;
        }
        InsnNode[] insns = mth.getInstructions();
        if (insns.length == 0) {
            return true;
        }
        for (InsnNode insn : insns) {
            if (insn == null || insn.getType() == InsnType.NOP || insn.getType() == InsnType.RETURN && insn.getArgsCount() == 0) continue;
            return false;
        }
        return true;
    }

    public void checkInstructions(MethodNode mth) {
        if (Utils.isEmpty(mth.getInstructions())) {
            return;
        }
        int regsCount = mth.getRegsCount();
        ArrayList<RegisterArg> list = new ArrayList<RegisterArg>();
        for (InsnNode insnNode : mth.getInstructions()) {
            if (insnNode == null) continue;
            list.clear();
            RegisterArg resultArg = insnNode.getResult();
            if (resultArg != null) {
                list.add(resultArg);
            }
            insnNode.getRegisterArgs(list);
            for (RegisterArg arg : list) {
                int regNum = arg.getRegNum();
                if (regNum < 0) {
                    throw new JadxRuntimeException("Incorrect negative register number in instruction: " + insnNode);
                }
                if (regNum < regsCount) continue;
                throw new JadxRuntimeException("Incorrect register number in instruction: " + insnNode + ", expected to be less than " + regsCount);
            }
        }
    }
}

