/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.loops;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.regions.loops.LoopType;

public final class ForEachLoop
extends LoopType {
    private final InsnNode varArgInsn = new InsnNode(InsnType.REGION_ARG, 0);
    private final InsnNode iterableArgInsn;

    public ForEachLoop(RegisterArg varArg, InsnArg iterableArg) {
        this.varArgInsn.add(AFlag.DONT_INLINE);
        this.varArgInsn.setResult(varArg.duplicate());
        this.iterableArgInsn = new InsnNode(InsnType.REGION_ARG, 1);
        this.iterableArgInsn.add(AFlag.DONT_INLINE);
        this.iterableArgInsn.addArg(iterableArg.duplicate());
        this.getVarArg().getSVar().getCodeVar().setDeclared(true);
    }

    public void injectFakeInsns(LoopRegion loopRegion) {
        loopRegion.getInfo().getPreHeader().getInstructions().add(this.iterableArgInsn);
        loopRegion.getHeader().getInstructions().add(0, this.varArgInsn);
    }

    public RegisterArg getVarArg() {
        return this.varArgInsn.getResult();
    }

    public InsnArg getIterableArg() {
        return this.iterableArgInsn.getArg(0);
    }
}

