/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhiInsn
extends InsnNode {
    private final List<BlockNode> blockBinds;

    public PhiInsn(int regNum, int predecessors) {
        this(predecessors);
        this.setResult(InsnArg.reg(regNum, ArgType.UNKNOWN));
        this.add(AFlag.DONT_INLINE);
        this.add(AFlag.DONT_GENERATE);
    }

    private PhiInsn(int argsCount) {
        super(InsnType.PHI, argsCount);
        this.blockBinds = new ArrayList<BlockNode>(argsCount);
    }

    public RegisterArg bindArg(BlockNode pred) {
        RegisterArg arg = InsnArg.reg(this.getResult().getRegNum(), this.getResult().getInitType());
        this.bindArg(arg, pred);
        return arg;
    }

    public void bindArg(RegisterArg arg, BlockNode pred) {
        if (this.blockBinds.contains(pred)) {
            throw new JadxRuntimeException("Duplicate predecessors in PHI insn: " + pred + ", " + this);
        }
        if (pred == null) {
            throw new JadxRuntimeException("Null bind block in PHI insn: " + this);
        }
        super.addArg(arg);
        this.blockBinds.add(pred);
    }

    @Nullable
    public BlockNode getBlockByArg(RegisterArg arg) {
        int index = this.getArgIndex(arg);
        if (index == -1) {
            return null;
        }
        return this.blockBinds.get(index);
    }

    public BlockNode getBlockByArgIndex(int argIndex) {
        return this.blockBinds.get(argIndex);
    }

    @Override
    @NotNull
    public RegisterArg getArg(int n) {
        return (RegisterArg)super.getArg(n);
    }

    @Override
    public boolean removeArg(InsnArg arg) {
        int index = this.getArgIndex(arg);
        if (index == -1) {
            return false;
        }
        this.removeArg(index);
        return true;
    }

    @Override
    public RegisterArg removeArg(int index) {
        RegisterArg reg = (RegisterArg)super.removeArg(index);
        this.blockBinds.remove(index);
        reg.getSVar().updateUsedInPhiList();
        return reg;
    }

    @Nullable
    public RegisterArg getArgBySsaVar(SSAVar ssaVar) {
        if (this.getArgsCount() == 0) {
            return null;
        }
        for (InsnArg insnArg : this.getArguments()) {
            RegisterArg reg = (RegisterArg)insnArg;
            if (reg.getSVar() != ssaVar) continue;
            return reg;
        }
        return null;
    }

    @Override
    public boolean replaceArg(InsnArg from, InsnArg to) {
        if (!(from instanceof RegisterArg) || !(to instanceof RegisterArg)) {
            return false;
        }
        int argIndex = this.getArgIndex(from);
        if (argIndex == -1) {
            return false;
        }
        ((RegisterArg)to).getSVar().addUsedInPhi(this);
        super.setArg(argIndex, to);
        InsnRemover.unbindArgUsage(null, from);
        ((RegisterArg)from).getSVar().updateUsedInPhiList();
        return true;
    }

    @Override
    public void addArg(InsnArg arg) {
        throw new JadxRuntimeException("Direct addArg is forbidden for PHI insn, bindArg must be used");
    }

    @Override
    public void setArg(int n, InsnArg arg) {
        throw new JadxRuntimeException("Direct setArg is forbidden for PHI insn, bindArg must be used");
    }

    @Override
    public InsnNode copy() {
        return this.copyCommonParams(new PhiInsn(this.getArgsCount()));
    }

    @Override
    public String toString() {
        return this.baseString() + " binds: " + this.blockBinds + this.attributesString();
    }
}

