/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InvokeCustomRawNode
extends InvokeNode {
    private final InvokeNode resolve;
    private List<EncodedValue> callSiteValues;

    public InvokeCustomRawNode(InvokeNode resolve, MethodInfo mthInfo, InsnData insn, boolean isRange) {
        super(mthInfo, insn, InvokeType.CUSTOM_RAW, false, isRange);
        this.resolve = resolve;
    }

    public InvokeCustomRawNode(InvokeNode resolve, MethodInfo mthInfo, InvokeType invokeType, int argsCount) {
        super(mthInfo, invokeType, argsCount);
        this.resolve = resolve;
    }

    public InvokeNode getResolveInvoke() {
        return this.resolve;
    }

    public void setCallSiteValues(List<EncodedValue> callSiteValues) {
        this.callSiteValues = callSiteValues;
    }

    public List<EncodedValue> getCallSiteValues() {
        return this.callSiteValues;
    }

    @Override
    public InsnNode copy() {
        InvokeCustomRawNode copy = new InvokeCustomRawNode(this.resolve, this.getCallMth(), this.getInvokeType(), this.getArgsCount());
        this.copyCommonParams(copy);
        copy.setCallSiteValues(this.callSiteValues);
        return copy;
    }

    @Override
    public boolean isStaticCall() {
        return true;
    }

    @Override
    public int getFirstArgOffset() {
        return 0;
    }

    @Override
    @Nullable
    public InsnArg getInstanceArg() {
        return null;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InvokeCustomRawNode) {
            return super.isSame(obj) && this.resolve.isSame(((InvokeCustomRawNode)obj).resolve);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(InsnUtils.formatOffset(this.offset)).append(": INVOKE_CUSTOM ");
        if (this.getResult() != null) {
            sb.append(this.getResult()).append(" = ");
        }
        if (!this.appendArgs(sb)) {
            sb.append('\n');
        }
        this.appendAttributes(sb);
        sb.append(" call-site: \n  ").append(Utils.listToString(this.callSiteValues, "\n  ")).append('\n');
        return sb.toString();
    }
}

