/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.MethodNode;
import java.util.EnumSet;
import java.util.Set;

public class CodeFeaturesAttr
implements IJadxAttribute {
    private final Set<CodeFeature> codeFeatures = EnumSet.noneOf(CodeFeature.class);

    public static boolean contains(MethodNode mth, CodeFeature feature) {
        CodeFeaturesAttr codeFeaturesAttr = mth.get(AType.METHOD_CODE_FEATURES);
        if (codeFeaturesAttr == null) {
            return false;
        }
        return codeFeaturesAttr.getCodeFeatures().contains((Object)feature);
    }

    public static void add(MethodNode mth, CodeFeature feature) {
        CodeFeaturesAttr codeFeaturesAttr = mth.get(AType.METHOD_CODE_FEATURES);
        if (codeFeaturesAttr == null) {
            codeFeaturesAttr = new CodeFeaturesAttr();
            mth.addAttr(codeFeaturesAttr);
        }
        codeFeaturesAttr.getCodeFeatures().add(feature);
    }

    public Set<CodeFeature> getCodeFeatures() {
        return this.codeFeatures;
    }

    public AType<CodeFeaturesAttr> getAttrType() {
        return AType.METHOD_CODE_FEATURES;
    }

    public String toAttrString() {
        return "CodeFeatures{" + this.codeFeatures + "}";
    }

    public static enum CodeFeature {
        SWITCH,
        NEW_ARRAY;

    }
}

