/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.metadata.annotations;

import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.annotations.VarNode;

public abstract class VarRef
implements ICodeAnnotation {
    public static VarRef fromPos(int refPos) {
        if (refPos == 0) {
            throw new IllegalArgumentException("Zero refPos");
        }
        return new FixedVarRef(refPos);
    }

    public static VarRef fromVarNode(VarNode varNode) {
        return new RelatedVarRef(varNode);
    }

    public abstract int getRefPos();

    @Override
    public ICodeAnnotation.AnnType getAnnType() {
        return ICodeAnnotation.AnnType.VAR_REF;
    }

    public String toString() {
        return "VarRef{" + this.getRefPos() + "}";
    }

    public static final class RelatedVarRef
    extends VarRef {
        private final VarNode varNode;

        public RelatedVarRef(VarNode varNode) {
            this.varNode = varNode;
        }

        @Override
        public int getRefPos() {
            return this.varNode.getDefPosition();
        }

        @Override
        public String toString() {
            return "VarRef{" + this.varNode + ", name=" + this.varNode.getName() + ", mth=" + this.varNode.getMth() + "}";
        }
    }

    public static final class FixedVarRef
    extends VarRef {
        private final int refPos;

        public FixedVarRef(int refPos) {
            this.refPos = refPos;
        }

        @Override
        public int getRefPos() {
            return this.refPos;
        }
    }
}

